/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.types;

import com.cloudrail.si.types.SandboxObject;
import java.util.Currency;

public class SubscriptionPlan
extends SandboxObject {
    private String id;
    private String name;
    private String description;
    private long created;
    private long amount;
    private String currency;
    private String interval;
    private long interval_count;

    public SubscriptionPlan(Long amount, Long created, String currency, String description, String id, String interval, Long interval_count, String name) {
        if (currency == null || description == null || id == null || interval == null || name == null) {
            throw new IllegalArgumentException("At least one of the parameters is undefined.");
        }
        if (amount < 0L) {
            throw new IllegalArgumentException("Amount can not be less than 0.");
        }
        if (Currency.getInstance(currency) == null) {
            throw new IllegalArgumentException("Passed currency is not a valid three-letter currency code.");
        }
        if (!(interval.equals("day") || interval.equals("week") || interval.equals("month") || interval.equals("year"))) {
            throw new IllegalArgumentException("Unknown interval. Allowed values are: 'day', 'week', 'month' or 'year'.");
        }
        this.amount = amount;
        this.created = created;
        this.currency = currency;
        this.description = description;
        this.id = id;
        this.interval = interval;
        this.interval_count = interval_count;
        this.name = name;
    }

    public Long getAmount() {
        return this.amount;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getInterval() {
        return this.interval;
    }

    public Long getInterval_count() {
        return this.interval_count;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionPlan)) {
            return false;
        }
        SubscriptionPlan that = (SubscriptionPlan)o;
        if (this.created != that.created) {
            return false;
        }
        if (this.amount != that.amount) {
            return false;
        }
        if (this.interval_count != that.interval_count) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.currency.equals(that.currency)) {
            return false;
        }
        return this.interval.equals(that.interval);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.amount ^ this.amount >>> 32);
        result = 31 * result + this.currency.hashCode();
        result = 31 * result + this.interval.hashCode();
        result = 31 * result + (int)(this.interval_count ^ this.interval_count >>> 32);
        return result;
    }

    public String toString() {
        return "SubscriptionPlan{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", created=" + this.created + ", amount=" + this.amount + ", currency='" + this.currency + '\'' + ", interval='" + this.interval + '\'' + ", interval_count=" + this.interval_count + '}';
    }
}

