/*
 * Decompiled with CFR 0.152.
 */
package com.cloudseal.client.tomcat;

import com.cloudseal.client.saml2.AuthRequestBuilder;
import com.cloudseal.client.saml2.AuthRequestContext;
import com.cloudseal.client.saml2.AuthResponseValidator;
import com.cloudseal.client.saml2.CloudsealPrincipal;
import com.cloudseal.client.saml2.IdentifierGenerator;
import com.cloudseal.client.saml2.IdpXmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.io.IOUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CloudsealAuthenticator
extends FormAuthenticator {
    public static final String AUTH_METHOD = "CLOUDSEAL";
    private static final String BROWSER_INITIATED_SSO_URL = "/logout.jsonp";
    private static final String ID = "com.cloudseal.client.tomcat.Authenticator.Id";
    private static final String AUDIENCE = "com.cloudseal.client.tomcat.Authenticator.Audience";
    private static final Log LOG = LogFactory.getLog(CloudsealAuthenticator.class);
    private IdentifierGenerator idGenerator;
    private AuthRequestBuilder authRequestBuilder;
    private AuthResponseValidator responseValidator;
    private IdpXmlParser idpXmlParser;
    private String idp;
    private String keystore;
    private String keystorePassword;
    private String key;
    private String keyPassword;
    private String appId;

    public CloudsealAuthenticator() throws Exception {
        this.setAlwaysUseSession(true);
    }

    protected String getAuthMethod() {
        return AUTH_METHOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        CloudsealAuthenticator cloudsealAuthenticator = this;
        synchronized (cloudsealAuthenticator) {
            LOG.info((Object)"Initializing");
            this.checkConfigParam(this.idp, "idp");
            this.checkConfigParam(this.keystore, "keystore");
            this.checkConfigParam(this.keystorePassword, "keystorePassword");
            this.checkConfigParam(this.key, "key");
            this.checkConfigParam(this.keyPassword, "keyPassword");
            try {
                AuthRequestContext authRequestContext = new AuthRequestContext();
                authRequestContext.setKeyName(this.key);
                authRequestContext.setKeyPassword(this.keyPassword);
                authRequestContext.setKeystore(this.getResource(this.keystore));
                authRequestContext.setKeystorePassword(this.keystorePassword);
                authRequestContext.setProviderName(this.appId);
                this.authRequestBuilder = new AuthRequestBuilder();
                this.authRequestBuilder.init(authRequestContext);
                this.responseValidator = new AuthResponseValidator();
                this.idpXmlParser = new IdpXmlParser();
                this.idpXmlParser.parse(this.getResource(this.idp));
                this.idGenerator = new IdentifierGenerator();
            }
            catch (Exception e) {
                throw new LifecycleException("Failed to initialize", (Throwable)e);
            }
        }
    }

    private void checkConfigParam(String param, String paramName) throws LifecycleException {
        if (param == null || param.length() < 1) {
            throw new LifecycleException("Missing configuration parameter: " + paramName);
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String authMethod;
        LOG.info((Object)"invoke()");
        if (request.getRequestURL().toString().endsWith(BROWSER_INITIATED_SSO_URL)) {
            LOG.info((Object)"browser initiated single log out");
            this.logout(request);
            String callback = request.getParameter("callback");
            String jsonp = String.format("%s({\"status\":\"success\"})", callback);
            response.getWriter().print(jsonp);
            response.getWriter().flush();
            return;
        }
        if (this.context.getLoginConfig() != null && (AUTH_METHOD.equals(authMethod = this.context.getLoginConfig().getAuthMethod()) || "NONE".equals(authMethod))) {
            super.invoke(request, response);
            return;
        }
        this.getNext().invoke(request, response);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        LOG.info((Object)"authenticate()");
        if (request.getUserPrincipal() != null) {
            return true;
        }
        if (request.getParameter("SAMLResponse") != null) {
            return this.processResponse(request, response);
        }
        this.redirectToIdp(request, response);
        return false;
    }

    boolean processResponse(Request request, HttpServletResponse response) throws IOException {
        try {
            Session session = request.getSessionInternal(false);
            if (session == null) {
                throw new Exception("Could not restore original request, no session found");
            }
            String expectedInResponseTo = (String)session.getSession().getAttribute(ID);
            String expectedAudience = (String)session.getSession().getAttribute(AUDIENCE);
            CloudsealPrincipal cloudsealPrincipal = this.responseValidator.validateResponse(this.idpXmlParser.getIdpPublicKey(), request.getParameter("SAMLResponse"), expectedInResponseTo, expectedAudience);
            this.restoreRequest(request, session);
            ArrayList roles = new ArrayList(cloudsealPrincipal.getRoles());
            GenericPrincipal principal = new GenericPrincipal(cloudsealPrincipal.getUsername(), null, roles, (Principal)cloudsealPrincipal);
            this.register(request, response, (Principal)principal, this.getAuthMethod(), principal.getName(), principal.getPassword());
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            this.sendForbiddenError(response, e.getMessage());
            return false;
        }
    }

    void redirectToIdp(Request request, HttpServletResponse response) throws IOException {
        try {
            String spIssuer = this.buildSpIssuer(request);
            String id = this.idGenerator.generateIdentifier();
            String acsUrl = this.buildAcsUrl(request);
            request.getSession().setAttribute(ID, (Object)id);
            request.getSession().setAttribute(AUDIENCE, (Object)spIssuer);
            String samlAuthRequest = this.authRequestBuilder.generateSamlAuthRequest(spIssuer, acsUrl, spIssuer, id);
            String redirectUrl = this.idpXmlParser.getSsoUrl() + "?" + samlAuthRequest;
            response.sendRedirect(redirectUrl);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            this.sendForbiddenError(response, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getResource(String filename) throws IOException {
        InputStream is;
        ServletContext servletContext = this.context.getServletContext();
        if (filename.startsWith("classpath:")) {
            String path = filename.split(":")[1];
            is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
        } else {
            is = servletContext.getResource(filename).openStream();
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    String buildSpIssuer(Request request) {
        String host = request.getHeader("Host");
        String protocol = "http://";
        if (request.isSecure()) {
            protocol = "https://";
        }
        if (host != null && host.length() > 0) {
            return protocol + host + "/saml/sp";
        }
        return protocol + "www.mycorp.com" + "/saml/sp";
    }

    String buildAcsUrl(Request request) {
        return request.getRequestURL().toString();
    }

    void sendForbiddenError(HttpServletResponse response, String error) throws IOException {
        response.sendError(403, error);
    }

    public void setIdp(String idp) {
        this.idp = idp;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }
}

