/*
 * Decompiled with CFR 0.152.
 */
package com.clouway.friendlyserve;

import com.clouway.friendlyserve.Request;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class TkRequestWrap
implements Request {
    private final transient HttpServletRequest req;

    public TkRequestWrap(HttpServletRequest req) {
        this.req = req;
    }

    @Override
    public String path() {
        return this.req.getRequestURI();
    }

    @Override
    public String param(String name) {
        return this.req.getParameter(name);
    }

    @Override
    public Iterable<String> names() {
        return this.req.getParameterMap().keySet();
    }

    @Override
    public Iterable<String> cookie(String name) {
        Cookie[] cookies = this.req.getCookies();
        if (cookies == null) {
            return new LinkedList<String>();
        }
        LinkedList values = Lists.newLinkedList();
        for (Cookie each : cookies) {
            if (!name.equalsIgnoreCase(each.getName())) continue;
            values.add(each.getValue());
        }
        return values;
    }

    @Override
    public String header(String name) {
        return this.req.getHeader(name);
    }

    @Override
    public InputStream body() throws IOException {
        return this.req.getInputStream();
    }
}

