/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.iam.avatar.application;

import com.clusterra.iam.avatar.application.AvatarData;
import com.clusterra.iam.avatar.application.AvatarImageResizeException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import org.springframework.core.io.Resource;

public class AvatarImageConverter {
    public static AvatarData getAvatarData(Resource resource) throws AvatarImageResizeException {
        return new AvatarData(AvatarImageConverter.resize(resource, 24), AvatarImageConverter.resize(resource, 48), AvatarImageConverter.resize(resource, 128));
    }

    private static byte[] resize(Resource resource, int size) throws AvatarImageResizeException {
        try {
            BufferedImage img = ImageIO.read(resource.getInputStream());
            BufferedImage resized = Scalr.resize((BufferedImage)img, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)size, (BufferedImageOp[])new BufferedImageOp[0]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resized, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AvatarImageResizeException(resource, size, e);
        }
    }
}

