/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.iam.avatar.application;

import com.clusterra.iam.avatar.application.AvatarData;
import com.clusterra.iam.avatar.application.AvatarId;
import com.clusterra.iam.avatar.application.AvatarImageConverter;
import com.clusterra.iam.avatar.application.AvatarImageResizeException;
import com.clusterra.iam.avatar.application.AvatarNotFoundException;
import com.clusterra.iam.avatar.application.AvatarService;
import com.clusterra.iam.avatar.application.Base64KeyGenerator;
import com.clusterra.iam.avatar.domain.model.Avatar;
import com.clusterra.iam.avatar.domain.model.AvatarRepository;
import com.clusterra.iam.avatar.domain.model.AvatarType;
import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AvatarServiceImpl
implements AvatarService {
    @Autowired
    private AvatarRepository avatarRepository;

    @Override
    @Transactional
    public AvatarData find(String id) throws AvatarNotFoundException {
        Avatar avatar = (Avatar)this.avatarRepository.findOne((Serializable)((Object)id));
        if (avatar == null) {
            throw new AvatarNotFoundException(id);
        }
        return new AvatarData(avatar.getImage24(), avatar.getImage48(), avatar.getImage128());
    }

    @Override
    @Transactional
    public AvatarId newAvatar(AvatarType type, AvatarData avatarData) {
        Validate.notNull((Object)avatarData, (String)"avatarData is null", (Object[])new Object[0]);
        Validate.notNull((Object)avatarData.getImage24(), (String)"avatarData.image24 is null", (Object[])new Object[0]);
        Validate.notNull((Object)avatarData.getImage48(), (String)"avatarData.image48 is null", (Object[])new Object[0]);
        Validate.notNull((Object)avatarData.getImage128(), (String)"avatarData.image128 is null", (Object[])new Object[0]);
        Avatar avatar = new Avatar(Base64KeyGenerator.generate(), type, avatarData.getImage24(), avatarData.getImage48(), avatarData.getImage128());
        this.avatarRepository.save(avatar);
        return new AvatarId(avatar.getId());
    }

    @Override
    @Transactional
    public AvatarId newAvatar(AvatarType type, Resource resource) throws AvatarImageResizeException {
        return this.newAvatar(type, AvatarImageConverter.getAvatarData(resource));
    }

    @Override
    @Transactional
    public AvatarId newDefaultAvatar(AvatarType type, AvatarData avatarData) {
        Avatar defaultAvatar = this.avatarRepository.findDefaultAvatar(type);
        if (defaultAvatar != null) {
            this.avatarRepository.delete(defaultAvatar);
        }
        Validate.notNull((Object)avatarData, (String)"avatarData is null", (Object[])new Object[0]);
        Validate.notNull((Object)avatarData.getImage24(), (String)"avatarData.image24 is null", (Object[])new Object[0]);
        Validate.notNull((Object)avatarData.getImage48(), (String)"avatarData.image48 is null", (Object[])new Object[0]);
        Validate.notNull((Object)avatarData.getImage128(), (String)"avatarData.image128 is null", (Object[])new Object[0]);
        Avatar avatar = new Avatar(Base64KeyGenerator.generate(), type, avatarData.getImage24(), avatarData.getImage48(), avatarData.getImage128());
        avatar.setDefault();
        this.avatarRepository.save(avatar);
        return new AvatarId(avatar.getId());
    }

    @Override
    @Transactional
    public AvatarId findDefaultAvatarId(AvatarType type) {
        Avatar avatar = this.avatarRepository.findDefaultAvatar(type);
        if (avatar == null) {
            throw new IllegalStateException("no default avatar for type <" + (Object)((Object)type) + ">");
        }
        return new AvatarId(avatar.getId());
    }

    @Override
    @Transactional
    public Boolean isDefaultAvatarAvailable(AvatarType type) {
        Avatar avatar = this.avatarRepository.findDefaultAvatar(type);
        return avatar != null;
    }
}

