/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.iam.avatar.application;

import com.clusterra.iam.avatar.application.AvatarImageConverter;
import com.clusterra.iam.avatar.application.AvatarImageResizeException;
import com.clusterra.iam.avatar.application.AvatarService;
import com.clusterra.iam.avatar.application.DefaultAvatarService;
import com.clusterra.iam.avatar.domain.model.AvatarType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class DefaultAvatarServiceImpl
implements DefaultAvatarService {
    private final Resource userImageResource;
    private final Resource customerImageResource;
    @Autowired
    private AvatarService avatarService;

    public DefaultAvatarServiceImpl(Resource userImageResource, Resource customerImageResource) {
        this.customerImageResource = customerImageResource;
        this.userImageResource = userImageResource;
    }

    @Override
    public void saveDefaults() throws AvatarImageResizeException {
        if (!this.avatarService.isDefaultAvatarAvailable(AvatarType.USER).booleanValue()) {
            this.avatarService.newDefaultAvatar(AvatarType.USER, AvatarImageConverter.getAvatarData(this.userImageResource));
        }
        if (!this.avatarService.isDefaultAvatarAvailable(AvatarType.TENANT).booleanValue()) {
            this.avatarService.newDefaultAvatar(AvatarType.TENANT, AvatarImageConverter.getAvatarData(this.customerImageResource));
        }
    }
}

