/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.iam.demo.application;

import com.clusterra.iam.avatar.application.AvatarId;
import com.clusterra.iam.avatar.application.AvatarImageResizeException;
import com.clusterra.iam.avatar.application.AvatarService;
import com.clusterra.iam.avatar.domain.model.AvatarType;
import com.clusterra.iam.core.application.group.GroupAlreadyExistsException;
import com.clusterra.iam.core.application.group.GroupDescriptor;
import com.clusterra.iam.core.application.group.GroupService;
import com.clusterra.iam.core.application.membership.AuthorizedMembershipService;
import com.clusterra.iam.core.application.role.ActionAlreadyAllowedException;
import com.clusterra.iam.core.application.role.ActionAlreadyExistsException;
import com.clusterra.iam.core.application.role.ActionDescriptor;
import com.clusterra.iam.core.application.role.ActionService;
import com.clusterra.iam.core.application.role.RoleAlreadyExistsException;
import com.clusterra.iam.core.application.role.RoleDescriptor;
import com.clusterra.iam.core.application.role.RoleNotFoundException;
import com.clusterra.iam.core.application.role.RoleService;
import com.clusterra.iam.core.application.tenant.InvalidTenantNameException;
import com.clusterra.iam.core.application.tenant.TenantAlreadyExistsException;
import com.clusterra.iam.core.application.tenant.TenantCommandService;
import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.iam.core.application.tenant.TenantNotFoundException;
import com.clusterra.iam.core.application.tenant.TenantQueryService;
import com.clusterra.iam.core.application.tenant.event.TenantActivatedEvent;
import com.clusterra.iam.core.application.user.EmailAlreadyExistsException;
import com.clusterra.iam.core.application.user.InvalidEmailException;
import com.clusterra.iam.core.application.user.LoginAlreadyExistsException;
import com.clusterra.iam.core.application.user.UserCommandService;
import com.clusterra.iam.core.application.user.UserId;
import com.clusterra.iam.core.domain.model.tenant.Tenant;
import com.clusterra.iam.core.domain.model.user.User;
import com.clusterra.iam.demo.application.DemoTenantService;
import com.clusterra.iam.demo.application.config.TenantConfig;
import com.clusterra.iam.demo.application.config.UserConfig;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DemoTenantServiceImpl
implements DemoTenantService {
    private static Logger logger = LoggerFactory.getLogger(DemoTenantServiceImpl.class);
    @Autowired
    private UserCommandService userCommandService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuthorizedMembershipService authorizedMembershipService;
    @Autowired
    private ActionService actionService;
    @Autowired
    private TenantCommandService tenantCommandService;
    @Autowired
    private AvatarService avatarService;
    @Autowired
    private ApplicationEventPublisher publisher;

    @Override
    @Transactional
    public void create(TenantConfig config) throws EmailAlreadyExistsException, TenantAlreadyExistsException, InvalidEmailException, RoleAlreadyExistsException, LoginAlreadyExistsException, TenantNotFoundException, InvalidTenantNameException {
        if (this.tenantQueryService.isNameTaken(config.getName())) {
            logger.info("skipping tenant creation '{}' as it already exists", (Object)config.getName());
            return;
        }
        Tenant tenant = this.tenantCommandService.create(config.getName(), config.getAdmin().getEmail());
        this.publisher.publishEvent((ApplicationEvent)new TenantActivatedEvent((Object)this, new TenantId(tenant.getId()), config.getAdmin().getLogin(), config.getAdmin().getPassword(), config.getAdmin().getEmail(), config.getAdmin().getFirstName(), config.getAdmin().getLastName()));
        TenantId tenantId = new TenantId(tenant.getId());
        try {
            AvatarId avatarId = this.avatarService.newAvatar(AvatarType.TENANT, config.getAvatarResource());
            this.tenantCommandService.updateAvatar(tenantId, avatarId.getId());
        }
        catch (AvatarImageResizeException e) {
            throw new RuntimeException(e);
        }
        for (UserConfig userConfig : config.getUserConfigs()) {
            User user = this.userCommandService.create(tenantId, userConfig.getLogin(), userConfig.getEmail(), userConfig.getPassword(), userConfig.getFirstName(), userConfig.getLastName());
            UserId userId = new UserId(user.getId());
            logger.info("user login={} for tenant={} created...", (Object)userConfig.getLogin(), (Object)config.getName());
            List<String> roles = Arrays.asList(StringUtils.split((String)userConfig.getRoles(), (String)","));
            GroupDescriptor group = null;
            try {
                group = this.groupService.createGroup(tenantId, tenant.getName() + RandomStringUtils.randomAlphabetic((int)5));
            }
            catch (GroupAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
            for (String role : roles) {
                RoleDescriptor roleDescriptor = this.setupRole(tenantId, role);
                this.authorizedMembershipService.createAuthorizedMembershipIfNotExists(tenantId, userId, roleDescriptor, group);
                logger.info("role name={}, user={}, tenant={} assigned...", new Object[]{roleDescriptor.getRoleName(), user.getLogin(), tenant.getName()});
            }
            RoleDescriptor userRole = this.roleService.findOrCreateRole(tenantId, "User");
            this.authorizedMembershipService.createAuthorizedMembershipIfNotExists(tenantId, userId, userRole, group);
        }
    }

    public RoleDescriptor setupRole(TenantId tenantId, String role) {
        try {
            RoleDescriptor roleDescriptor = this.createRoleIfNotExists(tenantId, role);
            this.allowActionsForRole(roleDescriptor, Arrays.asList("See Personal Details"));
            return roleDescriptor;
        }
        catch (ActionAlreadyAllowedException | ActionAlreadyExistsException | RoleAlreadyExistsException | RoleNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void allowActionsForRole(RoleDescriptor role, List<String> actionNames) throws ActionAlreadyExistsException, ActionAlreadyAllowedException {
        for (String actionName : actionNames) {
            ActionDescriptor action = this.createActionIfNotExists(actionName);
            if (this.actionService.isActionAllowed(action, role)) continue;
            this.actionService.allowActionForRole(action, role);
        }
    }

    private RoleDescriptor createRoleIfNotExists(TenantId tenant, String roleName) throws RoleAlreadyExistsException, RoleNotFoundException {
        if (!this.roleService.isRoleNameTaken(tenant, roleName)) {
            logger.info("creating new role:" + roleName);
            return this.roleService.createRole(tenant, roleName);
        }
        return this.roleService.findRoleByName(tenant, roleName);
    }

    private ActionDescriptor createActionIfNotExists(String actionName) throws ActionAlreadyExistsException {
        ActionDescriptor action = this.actionService.findActionByName(actionName);
        if (action == null) {
            logger.info("creating new action:" + actionName);
            return this.actionService.createAction(actionName);
        }
        return action;
    }
}

