/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.iam.demo.application.listen;

import com.clusterra.iam.core.application.role.RoleAlreadyExistsException;
import com.clusterra.iam.core.application.tenant.InvalidTenantNameException;
import com.clusterra.iam.core.application.tenant.TenantAlreadyExistsException;
import com.clusterra.iam.core.application.tenant.TenantNotFoundException;
import com.clusterra.iam.core.application.user.EmailAlreadyExistsException;
import com.clusterra.iam.core.application.user.InvalidEmailException;
import com.clusterra.iam.core.application.user.LoginAlreadyExistsException;
import com.clusterra.iam.demo.application.DemoTenantService;
import com.clusterra.iam.demo.application.config.TenantConfig;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class CreateDemoTenantsOnStartListener
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private DemoTenantService demoTenantService;
    @Autowired
    private List<TenantConfig> tenantConfigs;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        for (TenantConfig config : this.tenantConfigs) {
            try {
                this.demoTenantService.create(config);
            }
            catch (RoleAlreadyExistsException | InvalidTenantNameException | TenantAlreadyExistsException | TenantNotFoundException | EmailAlreadyExistsException | InvalidEmailException | LoginAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

