/*
 * Copyright (c) 2014.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.clusterra.pmbok.document.domain.model.document.repo;

import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.project.domain.model.ProjectVersion;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by dkuchugurov on 27.04.2014.
 */
public class DocumentProjectVersionsSpecification implements Specification<Document> {

    private final List<String> projectVersionIds;

    public DocumentProjectVersionsSpecification(List<ProjectVersion> projectVersions) {
        projectVersionIds = new ArrayList<>(projectVersions.size());
        for (ProjectVersion projectVersion : projectVersions) {
            projectVersionIds.add(projectVersion.getProjectVersionId().getId());
        }
    }

    @Override
    public Predicate toPredicate(Root<Document> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        if (projectVersionIds.isEmpty()) {
            return cb.isTrue(cb.literal(false));
        }
        return root.get("projectVersionId").as(String.class).in(projectVersionIds);
    }
}
