/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.context.support.ResourceBundleMessageSource;

public class ExposedResourceBundleMessageSource
extends ResourceBundleMessageSource {
    private Map<String, Map<String, String>> cachedData = new HashMap<String, Map<String, String>>();

    public Set<String> getKeys(String baseName, Locale locale) {
        ResourceBundle bundle = this.getResourceBundle(baseName, locale);
        return bundle.keySet();
    }

    public Map<String, String> getKeyValues(String basename, Locale locale) {
        String cacheKey = basename + locale.getCountry();
        if (this.cachedData.containsKey(cacheKey)) {
            return this.cachedData.get(cacheKey);
        }
        ResourceBundle bundle = this.getResourceBundle(basename, locale);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String key : bundle.keySet()) {
            treeMap.put(key, this.getMessage(key, null, locale));
        }
        this.cachedData.put(cacheKey, treeMap);
        return treeMap;
    }
}

