/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.application.document;

import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.application.document.DocumentCommandService;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.document.section.text.PersistedTextSectionContent;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.service.document.DocumentAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotEditableException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.reference.ReferenceAssociationService;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import com.clusterra.pmbok.document.domain.service.term.TermAssociationService;
import com.clusterra.pmbok.project.domain.model.ProjectVersionId;
import com.clusterra.pmbok.project.domain.service.ProjectVersionNotFoundException;
import com.clusterra.pmbok.reference.domain.model.reference.ReferenceId;
import com.clusterra.pmbok.reference.domain.service.ReferenceNotFoundException;
import com.clusterra.pmbok.term.domain.model.term.TermId;
import com.clusterra.pmbok.term.domain.service.TermNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocumentCommandServiceImpl
implements DocumentCommandService {
    @Autowired
    private DocumentDomainService documentDomainService;
    @Autowired
    private ReferenceAssociationService referenceAssociationService;
    @Autowired
    private TermAssociationService termAssociationService;
    @Autowired
    private IdentityTracker identityTracker;

    @Override
    @Transactional
    public Document create(ProjectVersionId projectVersionId, TemplateId templateId) throws ProjectVersionNotFoundException, DocumentAlreadyExistsException, TemplateNotFoundException, NotAuthenticatedException {
        return this.documentDomainService.create(this.identityTracker.currentTenant(), projectVersionId, templateId);
    }

    @Override
    @Transactional
    public void deleteBy(DocumentId documentId) throws DocumentNotFoundException {
        this.documentDomainService.deleteBy(documentId);
    }

    @Override
    @Transactional
    public Document publish(DocumentId documentId, String message) throws DocumentNotFoundException {
        return this.documentDomainService.publish(documentId, message);
    }

    @Override
    @Transactional
    public Document approve(DocumentId documentId, String message) throws DocumentNotFoundException {
        return this.documentDomainService.approve(documentId, message);
    }

    @Override
    @Transactional
    public Document edit(DocumentId documentId) throws DocumentNotFoundException, DocumentNotEditableException {
        return this.documentDomainService.edit(documentId);
    }

    @Override
    @Transactional
    public PersistedTextSectionContent updateTextSection(DocumentId documentId, SectionTemplateId sectionTemplateId, String text) throws DocumentNotFoundException, SectionTemplateNotFoundException {
        return this.documentDomainService.updateTextSection(documentId, sectionTemplateId, text);
    }

    @Override
    @Transactional
    public void createAssociation(DocumentId documentId, ReferenceId referenceId) throws NotAuthenticatedException, ReferenceNotFoundException, DocumentNotFoundException {
        this.referenceAssociationService.createAssociation(this.identityTracker.currentTenant(), documentId, referenceId);
    }

    @Override
    @Transactional
    public void deleteAssociation(DocumentId documentId, ReferenceId referenceId) throws NotAuthenticatedException, ReferenceNotFoundException, DocumentNotFoundException {
        this.referenceAssociationService.deleteAssociation(this.identityTracker.currentTenant(), documentId, referenceId);
    }

    @Override
    @Transactional
    public void createAssociation(DocumentId documentId, TermId termId) throws NotAuthenticatedException, TermNotFoundException, DocumentNotFoundException {
        this.termAssociationService.createAssociation(this.identityTracker.currentTenant(), documentId, termId);
    }

    @Override
    @Transactional
    public void deleteAssociation(DocumentId documentId, TermId termId) throws NotAuthenticatedException, TermNotFoundException, DocumentNotFoundException {
        this.termAssociationService.deleteAssociation(this.identityTracker.currentTenant(), documentId, termId);
    }
}

