/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.application.document;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.application.document.DocumentQueryService;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.document.DocumentRevision;
import com.clusterra.pmbok.document.domain.model.document.section.SectionContent;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.reference.ReferenceAssociationService;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import com.clusterra.pmbok.document.domain.service.term.TermAssociationService;
import com.clusterra.pmbok.project.domain.model.ProjectId;
import com.clusterra.pmbok.project.domain.model.ProjectVersionId;
import com.clusterra.pmbok.project.domain.service.ProjectNotFoundException;
import com.clusterra.pmbok.reference.domain.model.reference.Reference;
import com.clusterra.pmbok.term.domain.model.term.Term;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocumentQueryServiceImpl
implements DocumentQueryService {
    @Autowired
    private DocumentDomainService documentDomainService;
    @Autowired
    private TermAssociationService termAssociationService;
    @Autowired
    private ReferenceAssociationService referenceAssociationService;
    @Autowired
    private IdentityTracker identityTracker;

    @Override
    @Transactional
    public Document findBy(DocumentId documentId) throws DocumentNotFoundException {
        return this.documentDomainService.findBy(documentId);
    }

    @Override
    @Transactional
    public Page<Document> findBy(Pageable pageable, String searchBy) throws NotAuthenticatedException {
        TenantId tenantId = this.identityTracker.currentTenant();
        return this.documentDomainService.findBy(tenantId, pageable, searchBy);
    }

    @Override
    @Transactional
    public Page<Document> findBy(Pageable pageable, ProjectId projectId, String searchBy) throws ProjectNotFoundException, NotAuthenticatedException {
        TenantId tenantId = this.identityTracker.currentTenant();
        return this.documentDomainService.findBy(tenantId, pageable, projectId, searchBy);
    }

    @Override
    @Transactional
    public Page<Document> findBy(Pageable pageable, ProjectVersionId projectVersionId, String searchBy) throws NotAuthenticatedException {
        TenantId tenantId = this.identityTracker.currentTenant();
        return this.documentDomainService.findBy(tenantId, pageable, projectVersionId, searchBy);
    }

    @Override
    @Transactional
    public Set<Template> findUsedTemplates(ProjectVersionId projectVersionId) {
        return this.documentDomainService.findUsedTemplates(projectVersionId);
    }

    @Override
    @Transactional
    public DocumentRevision getRevision(DocumentId documentId) throws DocumentNotFoundException {
        return this.documentDomainService.getRevision(documentId);
    }

    @Override
    @Transactional
    public List<SectionContent> findSectionContents(DocumentId documentId) throws DocumentNotFoundException, TemplateNotFoundException, NotAuthenticatedException {
        return this.documentDomainService.findSectionContentsBy(this.identityTracker.currentTenant(), documentId);
    }

    @Override
    @Transactional
    public Page<Term> getAssociatedTerms(Pageable pageable, DocumentId documentId, String searchBy) throws DocumentNotFoundException, NotAuthenticatedException {
        return this.termAssociationService.findBy(this.identityTracker.currentTenant(), pageable, documentId, searchBy);
    }

    @Override
    @Transactional
    public Page<Reference> getAssociatedReferences(Pageable pageable, DocumentId documentId, String searchBy) throws DocumentNotFoundException, NotAuthenticatedException {
        return this.referenceAssociationService.findBy(this.identityTracker.currentTenant(), pageable, documentId, searchBy);
    }
}

