/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.application.template;

import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.application.template.TemplateService;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionType;
import com.clusterra.pmbok.document.domain.service.template.TemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.template.TemplateDomainService;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateServiceImpl
implements TemplateService {
    @Autowired
    private TemplateDomainService service;
    @Autowired
    private IdentityTracker identityTracker;

    @Override
    @Transactional
    public Template createTemplate(Integer majorVersion, Integer minorVersion, String name) throws NotAuthenticatedException, TemplateAlreadyExistsException {
        return this.service.createTemplate(this.identityTracker.currentTenant(), majorVersion, minorVersion, name);
    }

    @Override
    @Transactional
    public Template updateTemplateName(TemplateId templateId, String name) throws TemplateNotFoundException {
        return this.service.updateTemplateName(templateId, name);
    }

    @Override
    @Transactional
    public void deleteTemplate(TemplateId templateId) throws TemplateNotFoundException {
        this.service.deleteTemplate(templateId);
    }

    @Override
    @Transactional
    public SectionTemplate addHistorySection(TemplateId templateId, String name) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException {
        return this.service.addHistorySection(templateId, name);
    }

    @Override
    @Transactional
    public SectionTemplate addReferenceSection(TemplateId templateId, String name) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException {
        return this.service.addReferenceSection(templateId, name);
    }

    @Override
    @Transactional
    public SectionTemplate addTermSection(TemplateId templateId, String name) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException {
        return this.service.addTermSection(templateId, name);
    }

    @Override
    @Transactional
    public SectionTemplate addTextSection(TemplateId templateId, String name) throws TemplateNotFoundException {
        return this.service.addTextSection(templateId, name);
    }

    @Override
    @Transactional
    public SectionTemplate addTitleSection(TemplateId templateId, String name) throws TemplateNotFoundException {
        return this.service.addTitleSection(templateId, name);
    }

    @Override
    @Transactional
    public SectionTemplate addTocSection(TemplateId templateId, String name) throws TemplateNotFoundException {
        return this.service.addTocSection(templateId, name);
    }

    @Override
    @Transactional
    public void removeSection(TemplateId templateId, SectionTemplateId sectionTemplateId) throws TemplateNotFoundException, SectionTemplateNotFoundException {
        this.service.removeSection(templateId, sectionTemplateId);
    }

    @Override
    @Transactional
    public SectionTemplate updateSectionOrder(TemplateId templateId, SectionTemplateId sectionTemplateId, Integer orderIndex) throws SectionTemplateNotFoundException, TemplateNotFoundException {
        return this.service.updateSectionOrder(templateId, sectionTemplateId, orderIndex);
    }

    @Override
    @Transactional
    public SectionTemplate updateSectionName(TemplateId templateId, SectionTemplateId sectionTemplateId, String name) throws SectionTemplateNotFoundException, TemplateNotFoundException {
        return this.service.updateSectionName(templateId, sectionTemplateId, name);
    }

    @Override
    @Transactional
    public List<Template> findAllTemplates() throws NotAuthenticatedException {
        return this.service.findAllTemplates(this.identityTracker.currentTenant());
    }

    @Override
    @Transactional
    public Page<Template> findBy(Pageable pageable, String searchBy) throws NotAuthenticatedException {
        return this.service.findBy(this.identityTracker.currentTenant(), pageable, searchBy);
    }

    @Override
    @Transactional
    public List<SectionTemplate> findSectionTemplates(TemplateId templateId) throws TemplateNotFoundException {
        return this.service.findSectionTemplates(templateId);
    }

    @Override
    @Transactional
    public SectionTemplate findSectionTemplateBy(SectionTemplateId sectionTemplateId) throws SectionTemplateNotFoundException {
        return this.service.findSectionTemplateBy(sectionTemplateId);
    }

    @Override
    @Transactional
    public Set<SectionType> findSectionTypesUsedBy(TemplateId templateId) throws TemplateNotFoundException {
        return this.service.findSectionTypesUsedBy(templateId);
    }

    @Override
    @Transactional
    public Template findBy(TemplateId templateId) throws TemplateNotFoundException {
        return this.service.findBy(templateId);
    }
}

