/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.model.document;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.iam.core.application.user.UserId;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.document.Status;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.project.domain.model.ProjectId;
import com.clusterra.pmbok.project.domain.model.ProjectVersionId;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
@Table(name="pmb_doc")
@Inheritance(strategy=InheritanceType.JOINED)
public class Document {
    @Id
    @GeneratedValue(generator="base64")
    @GenericGenerator(name="base64", strategy="com.clusterra.hibernate.base64.Base64IdGenerator")
    private String id;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private Status status;
    @Basic
    @Column(nullable=false)
    private String tenantId;
    @Basic
    @CreatedDate
    private Date createdDate;
    @Basic
    @CreatedBy
    private String createdByUserId;
    @Basic
    @LastModifiedDate
    private Date modifiedDate;
    @Basic
    @LastModifiedBy
    private String modifiedByUserId;
    @ManyToOne
    private Template template;
    @Basic
    @Column(nullable=false)
    private String projectVersionId;
    @Basic
    @Column(nullable=false)
    private String projectId;
    @Basic
    private int revision;
    @Basic
    private int touchCounter;

    Document() {
    }

    public Document(Template template, TenantId tenantId, ProjectId projectId, ProjectVersionId projectVersionId) {
        Validate.notNull((Object)tenantId, (String)"tenantId is null", (Object[])new Object[0]);
        Validate.notNull((Object)projectVersionId, (String)"projectVersionId is null", (Object[])new Object[0]);
        Validate.notNull((Object)template, (String)"template is null", (Object[])new Object[0]);
        Validate.notNull((Object)projectId, (String)"projectId is null", (Object[])new Object[0]);
        this.tenantId = tenantId.getId();
        this.projectVersionId = projectVersionId.getId();
        this.projectId = projectId.getId();
        this.template = template;
        this.status = Status.NEW;
        this.touchCounter = 0;
    }

    public void touch() {
        ++this.touchCounter;
    }

    public DocumentId getDocumentId() {
        return new DocumentId(this.id);
    }

    public ProjectId getProjectId() {
        return new ProjectId(this.projectId);
    }

    public void publish() {
        this.status = Status.PUBLISHED;
        this.incrementVersion();
    }

    public void approve() {
        this.status = Status.APPROVED;
    }

    public void edit() {
        this.status = Status.EDITING;
    }

    public TenantId getTenantId() {
        return new TenantId(this.tenantId);
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public UserId getCreatedByUserId() {
        return new UserId(this.createdByUserId);
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public UserId getModifiedByUserId() {
        return new UserId(this.modifiedByUserId);
    }

    public ProjectVersionId getProjectVersionId() {
        return new ProjectVersionId(this.projectVersionId);
    }

    public Template getTemplate() {
        return this.template;
    }

    private void incrementVersion() {
        ++this.revision;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return !(this.id != null ? !this.id.equals(document.id) : document.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

