/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.model.history;

import com.clusterra.pmbok.document.domain.model.document.Document;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
@Table(name="pmb_doc_history_entry")
public class HistoryEntry {
    @Id
    @GeneratedValue(generator="base64")
    @GenericGenerator(name="base64", strategy="com.clusterra.hibernate.base64.Base64IdGenerator")
    private String id;
    @Basic
    @Column(nullable=false)
    private String revision;
    @Basic
    @CreatedDate
    private Date createdDate;
    @Basic
    @CreatedBy
    private String createdByUserId;
    @Basic
    @Column(length=3000)
    private String comment;
    @ManyToOne
    private Document document;

    HistoryEntry() {
    }

    public HistoryEntry(Document document, String revision, String comment) {
        Validate.notNull((Object)document);
        Validate.notEmpty((CharSequence)revision, (String)"revision is empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)comment, (String)"comment is empty", (Object[])new Object[0]);
        this.document = document;
        this.revision = revision;
        this.comment = comment;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getId() {
        return this.id;
    }

    public String getRevision() {
        return this.revision;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public String getComment() {
        return this.comment;
    }
}

