/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.model.template;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.pmbok.document.domain.model.document.Version;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.TemplateStatus;
import com.clusterra.pmbok.document.domain.model.template.repo.SectionTemplateRepository;
import com.clusterra.pmbok.document.domain.model.template.section.HistorySectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.ReferenceSectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionType;
import com.clusterra.pmbok.document.domain.model.template.section.TermSectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.TextSectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.TitleSectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.TocSectionTemplate;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
@Table(name="pmb_doc_template")
public class Template {
    @Id
    @GeneratedValue(generator="base64")
    @GenericGenerator(name="base64", strategy="com.clusterra.hibernate.base64.Base64IdGenerator")
    private String id;
    @Basic
    @Column(nullable=false)
    private String tenantId;
    @Basic
    @CreatedDate
    private Date createdDate;
    @Basic
    @CreatedBy
    private String createdByUserId;
    @Basic
    @LastModifiedDate
    private Date modifiedDate;
    @Basic
    @LastModifiedBy
    private String modifiedByUserId;
    @Embedded
    private Version version;
    @Basic
    private String name;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TemplateStatus status;
    @Basic
    private int touchCounter;

    Template() {
    }

    public Template(TenantId tenantId, Version version, String name) {
        Validate.notNull((Object)tenantId);
        Validate.notNull((Object)version);
        this.tenantId = tenantId.getId();
        this.version = version;
        this.touchCounter = 0;
        this.status = TemplateStatus.NEW;
        this.setName(name);
    }

    public void touch() {
        ++this.touchCounter;
        this.status = TemplateStatus.EDITING;
    }

    public void markReady() {
        this.status = TemplateStatus.READY;
    }

    public TemplateStatus getStatus() {
        return this.status;
    }

    public SectionTemplate addHistorySection(String name, SectionTemplateRepository<SectionTemplate> repository) throws SectionTemplateAlreadyExistsException {
        this.checkSectionNotExists(SectionType.SECTION_HISTORY, repository);
        int count = this.calculateOrderIndex(repository);
        HistorySectionTemplate sectionTemplate = new HistorySectionTemplate(this, name, count);
        return (SectionTemplate)repository.save(sectionTemplate);
    }

    public SectionTemplate addTermSection(String name, SectionTemplateRepository<SectionTemplate> repository) throws SectionTemplateAlreadyExistsException {
        this.checkSectionNotExists(SectionType.SECTION_TERM, repository);
        int count = this.calculateOrderIndex(repository);
        TermSectionTemplate sectionTemplate = new TermSectionTemplate(this, name, count);
        return (SectionTemplate)repository.save(sectionTemplate);
    }

    public ReferenceSectionTemplate addReferenceSection(String name, SectionTemplateRepository<SectionTemplate> repository) throws SectionTemplateAlreadyExistsException {
        this.checkSectionNotExists(SectionType.SECTION_REFERENCE, repository);
        int count = this.calculateOrderIndex(repository);
        ReferenceSectionTemplate sectionTemplate = new ReferenceSectionTemplate(this, name, count);
        return (ReferenceSectionTemplate)repository.save(sectionTemplate);
    }

    private void checkSectionNotExists(SectionType type, SectionTemplateRepository<SectionTemplate> repository) throws SectionTemplateAlreadyExistsException {
        SectionTemplate section = repository.findBy(this, type);
        if (section != null) {
            throw new SectionTemplateAlreadyExistsException(this.getTemplateId(), type);
        }
    }

    private int calculateOrderIndex(SectionTemplateRepository repository) {
        return repository.countBy(this);
    }

    public TextSectionTemplate addTextSection(String name, SectionTemplateRepository<SectionTemplate> repository) {
        int count = this.calculateOrderIndex(repository);
        TextSectionTemplate sectionTemplate = new TextSectionTemplate(this, name, count);
        repository.save(sectionTemplate);
        return sectionTemplate;
    }

    public SectionTemplate addTitleSection(String name, SectionTemplateRepository<SectionTemplate> repository) {
        int count = this.calculateOrderIndex(repository);
        TitleSectionTemplate sectionTemplate = new TitleSectionTemplate(this, name, count);
        repository.save(sectionTemplate);
        return sectionTemplate;
    }

    public SectionTemplate addTocSection(String name, SectionTemplateRepository<SectionTemplate> repository) {
        int count = this.calculateOrderIndex(repository);
        TocSectionTemplate sectionTemplate = new TocSectionTemplate(this, name, count);
        repository.save(sectionTemplate);
        return sectionTemplate;
    }

    public void removeAllSections(SectionTemplateRepository<SectionTemplate> repository) {
        List<SectionTemplate> sectionTemplates = repository.findBy(this);
        repository.delete(sectionTemplates);
    }

    public void removeSection(SectionTemplateId sectionTemplateId, SectionTemplateRepository<SectionTemplate> repository) throws SectionTemplateNotFoundException {
        SectionTemplate template = this.findSectionTemplate(sectionTemplateId, repository);
        repository.delete(template);
    }

    private SectionTemplate findSectionTemplate(SectionTemplateId sectionTemplateId, SectionTemplateRepository<SectionTemplate> repository) throws SectionTemplateNotFoundException {
        Validate.notNull((Object)((Object)sectionTemplateId));
        SectionTemplate sectionTemplate = (SectionTemplate)repository.findOne((Serializable)((Object)sectionTemplateId.getId()));
        if (sectionTemplate == null) {
            throw new SectionTemplateNotFoundException(sectionTemplateId);
        }
        return sectionTemplate;
    }

    public SectionTemplate setOrder(SectionTemplateId sectionTemplateId, Integer orderIndex, SectionTemplateRepository<SectionTemplate> repository) throws SectionTemplateNotFoundException {
        SectionTemplate sectionTemplate = this.findSectionTemplate(sectionTemplateId, repository);
        Integer count = this.calculateOrderIndex(repository);
        Validate.inclusiveBetween((Object)0, (Object)count, (Comparable)orderIndex);
        if (sectionTemplate.getOrderIndex().equals(orderIndex)) {
            return sectionTemplate;
        }
        int newIndexAdjustedWithOrder = sectionTemplate.getOrderIndex() >= orderIndex ? orderIndex - 1 : orderIndex + 1;
        sectionTemplate.setOrderIndex(newIndexAdjustedWithOrder);
        List<SectionTemplate> sections = repository.findBy(this);
        for (SectionTemplate template : sections) {
            int i = sections.indexOf(template);
            template.setOrderIndex(i);
            repository.save(template);
        }
        return sectionTemplate;
    }

    public TemplateId getTemplateId() {
        return new TemplateId(this.id);
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public String getModifiedByUserId() {
        return this.modifiedByUserId;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Validate.notNull((Object)name);
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template that = (Template)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Template{id='" + this.id + '\'' + ", tenantId='" + this.tenantId + '\'' + ", createdDate=" + this.createdDate + ", createdByUserId='" + this.createdByUserId + '\'' + ", modifiedDate=" + this.modifiedDate + ", modifiedByUserId='" + this.modifiedByUserId + '\'' + ", version=" + this.version + ", name='" + this.name + '\'' + ", status=" + (Object)((Object)this.status) + ", touchCounter=" + this.touchCounter + '}';
    }
}

