/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.model.template.section;

import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.section.SectionContent;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionType;
import com.clusterra.pmbok.document.domain.service.document.SectionContentBuilder;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(name="pmb_section_template")
public abstract class SectionTemplate {
    @Id
    @GeneratedValue(generator="base64")
    @GenericGenerator(name="base64", strategy="com.clusterra.hibernate.base64.Base64IdGenerator")
    private String id;
    @Basic
    @CreatedDate
    private Date createdDate;
    @Basic
    @CreatedBy
    private String createdByUserId;
    @Basic
    @LastModifiedDate
    private Date modifiedDate;
    @Basic
    @LastModifiedBy
    private String modifiedByUserId;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private SectionType type;
    @Basic
    private String name;
    @ManyToOne
    private Template template;
    @Basic
    @Column(nullable=false)
    private Integer orderIndex;

    SectionTemplate() {
    }

    public SectionTemplate(Template template, SectionType type, String name, Integer orderIndex) {
        Validate.notNull((Object)template);
        Validate.notNull((Object)((Object)type));
        Validate.notEmpty((CharSequence)name);
        Validate.notNull((Object)orderIndex);
        this.template = template;
        this.type = type;
        this.name = name;
        Validate.inclusiveBetween((Object)0, (Object)Integer.MAX_VALUE, (Comparable)orderIndex);
        this.orderIndex = orderIndex;
    }

    public abstract SectionContent getSectionContent(Document var1, SectionContentBuilder var2);

    public Template getTemplate() {
        return this.template;
    }

    public String getTitle() {
        return String.format("%s. %s", this.orderIndex + 1, this.name);
    }

    public Integer getOrderIndex() {
        return this.orderIndex;
    }

    public void setOrderIndex(Integer orderIndex) {
        Validate.notNull((Object)orderIndex);
        this.orderIndex = orderIndex;
    }

    public SectionTemplateId getSectionTemplateId() {
        return new SectionTemplateId(this.id);
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public String getModifiedByUserId() {
        return this.modifiedByUserId;
    }

    public SectionType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Validate.notEmpty((CharSequence)name);
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SectionTemplate that = (SectionTemplate)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "SectionTemplate{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", orderIndex=" + this.orderIndex + ", type=" + (Object)((Object)this.type) + '}';
    }
}

