/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.model.term;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.pmbok.document.domain.model.document.Document;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.Validate;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;

@Entity
@Table(name="pmb_doc_term_association", uniqueConstraints={@UniqueConstraint(columnNames={"termId", "document_id"})})
public class TermAssociation {
    @Id
    @GeneratedValue(generator="base64")
    @GenericGenerator(name="base64", strategy="com.clusterra.hibernate.base64.Base64IdGenerator")
    private String id;
    @Basic
    @Column(nullable=false)
    private String tenantId;
    @Basic
    @CreatedDate
    private Date createdDate;
    @Basic
    @CreatedBy
    private String createdByUserId;
    @Basic
    @Column(nullable=false)
    private String termId;
    @ManyToOne
    private Document document;

    TermAssociation() {
    }

    public TermAssociation(TenantId tenantId, String termId, Document document) {
        Validate.notNull((Object)tenantId);
        Validate.notNull((Object)termId);
        Validate.notNull((Object)document);
        this.tenantId = tenantId.getId();
        this.termId = termId;
        this.document = document;
    }

    public String getId() {
        return this.id;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermAssociation that = (TermAssociation)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

