/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.document;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.document.DocumentRevision;
import com.clusterra.pmbok.document.domain.model.document.section.SectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.text.PersistedTextSectionContent;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.service.document.DocumentAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotEditableException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import com.clusterra.pmbok.project.domain.model.ProjectId;
import com.clusterra.pmbok.project.domain.model.ProjectVersionId;
import com.clusterra.pmbok.project.domain.service.ProjectNotFoundException;
import com.clusterra.pmbok.project.domain.service.ProjectVersionNotFoundException;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface DocumentDomainService {
    public Document create(TenantId var1, ProjectVersionId var2, TemplateId var3) throws DocumentAlreadyExistsException, ProjectVersionNotFoundException, TemplateNotFoundException;

    public void deleteBy(DocumentId var1) throws DocumentNotFoundException;

    public void deleteBy(ProjectVersionId var1) throws DocumentNotFoundException;

    public Document publish(DocumentId var1, String var2) throws DocumentNotFoundException;

    public Document approve(DocumentId var1, String var2) throws DocumentNotFoundException;

    public Document edit(DocumentId var1) throws DocumentNotFoundException, DocumentNotEditableException;

    public Document findBy(DocumentId var1) throws DocumentNotFoundException;

    public List<Document> findBy(TemplateId var1) throws TemplateNotFoundException;

    public Page<Document> findBy(TenantId var1, Pageable var2, String var3);

    public Page<Document> findBy(TenantId var1, Pageable var2, ProjectId var3, String var4) throws ProjectNotFoundException;

    public Page<Document> findBy(TenantId var1, Pageable var2, ProjectVersionId var3, String var4);

    public Set<Template> findUsedTemplates(ProjectVersionId var1);

    public DocumentRevision getRevision(DocumentId var1) throws DocumentNotFoundException;

    public List<SectionContent> findSectionContentsBy(TenantId var1, DocumentId var2) throws DocumentNotFoundException, TemplateNotFoundException;

    public PersistedTextSectionContent updateTextSection(DocumentId var1, SectionTemplateId var2, String var3) throws DocumentNotFoundException, SectionTemplateNotFoundException;
}

