/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.document;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.iam.core.application.tenant.TenantNotFoundException;
import com.clusterra.iam.core.application.tenant.TenantQueryService;
import com.clusterra.iam.core.domain.model.tenant.Tenant;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.document.DocumentRevision;
import com.clusterra.pmbok.document.domain.model.document.Status;
import com.clusterra.pmbok.document.domain.model.document.event.DocumentApprovedEvent;
import com.clusterra.pmbok.document.domain.model.document.event.DocumentCreatedEvent;
import com.clusterra.pmbok.document.domain.model.document.event.DocumentDeletedEvent;
import com.clusterra.pmbok.document.domain.model.document.event.DocumentDeletingEvent;
import com.clusterra.pmbok.document.domain.model.document.event.DocumentEditingEvent;
import com.clusterra.pmbok.document.domain.model.document.event.DocumentPublishedEvent;
import com.clusterra.pmbok.document.domain.model.document.event.TextSectionUpdatedEvent;
import com.clusterra.pmbok.document.domain.model.document.repo.DocumentProjectVersionSpecification;
import com.clusterra.pmbok.document.domain.model.document.repo.DocumentProjectVersionsSpecification;
import com.clusterra.pmbok.document.domain.model.document.repo.DocumentRepository;
import com.clusterra.pmbok.document.domain.model.document.repo.DocumentSearchBySpecification;
import com.clusterra.pmbok.document.domain.model.document.repo.DocumentTenantSpecification;
import com.clusterra.pmbok.document.domain.model.document.section.PersistedSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.SectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.repo.PersistedSectionContentRepository;
import com.clusterra.pmbok.document.domain.model.document.section.text.PersistedTextSectionContent;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.repo.SectionTemplateRepository;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.service.document.DocumentAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotEditableException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.document.SectionContentBuilder;
import com.clusterra.pmbok.document.domain.service.template.TemplateDomainService;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import com.clusterra.pmbok.project.domain.model.ProjectId;
import com.clusterra.pmbok.project.domain.model.ProjectVersion;
import com.clusterra.pmbok.project.domain.model.ProjectVersionId;
import com.clusterra.pmbok.project.domain.model.repo.ProjectVersionRepository;
import com.clusterra.pmbok.project.domain.service.ProjectDomainQueryService;
import com.clusterra.pmbok.project.domain.service.ProjectNotFoundException;
import com.clusterra.pmbok.project.domain.service.ProjectVersionNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.MANDATORY)
public class DocumentDomainServiceImpl
implements DocumentDomainService {
    @Autowired
    private DocumentRepository documentRepository;
    @Autowired
    private ProjectVersionRepository projectVersionRepository;
    @Autowired
    private TemplateDomainService templateDomainService;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private ProjectDomainQueryService projectDomainQueryService;
    @Autowired
    private SectionTemplateRepository<SectionTemplate> sectionTemplateRepository;
    @Autowired
    private SectionContentBuilder sectionContentBuilder;
    @Autowired
    private PersistedSectionContentRepository<PersistedSectionContent> persistedSectionContentRepository;
    @Autowired
    private TenantQueryService tenantQueryService;

    @Override
    public Document create(TenantId tenantId, ProjectVersionId projectVersionId, TemplateId templateId) throws DocumentAlreadyExistsException, ProjectVersionNotFoundException, TemplateNotFoundException {
        ProjectVersion projectVersion = (ProjectVersion)this.projectVersionRepository.findOne((Serializable)((Object)projectVersionId.getId()));
        if (projectVersion == null) {
            throw new ProjectVersionNotFoundException(projectVersionId);
        }
        Template template = this.templateDomainService.findBy(templateId);
        Document existing = this.documentRepository.findBy(projectVersionId.getId(), template);
        if (existing != null) {
            throw new DocumentAlreadyExistsException(projectVersionId, templateId);
        }
        Document document = new Document(template, tenantId, projectVersion.getProject().getProjectId(), projectVersionId);
        this.documentRepository.save(document);
        this.publisher.publishEvent((ApplicationEvent)new DocumentCreatedEvent(this, tenantId, document.getProjectId(), document.getDocumentId(), templateId, document.getCreatedByUserId()));
        return document;
    }

    @Override
    public void deleteBy(DocumentId documentId) throws DocumentNotFoundException {
        Document document = this.getDocument(documentId);
        this.publisher.publishEvent((ApplicationEvent)new DocumentDeletingEvent(this, documentId));
        this.documentRepository.delete(document);
        this.publisher.publishEvent((ApplicationEvent)new DocumentDeletedEvent(this, document.getProjectId(), documentId));
    }

    @Override
    public void deleteBy(ProjectVersionId projectVersionId) throws DocumentNotFoundException {
        List<Document> documents = this.documentRepository.findByProjectVersionId(projectVersionId.getId());
        for (Document document : documents) {
            this.deleteBy(document.getDocumentId());
        }
    }

    @Override
    public Document publish(DocumentId documentId, String message) throws DocumentNotFoundException {
        Validate.notEmpty((CharSequence)message, (String)"message is empty", (Object[])new Object[0]);
        Document document = this.getDocument(documentId);
        document.publish();
        this.publisher.publishEvent((ApplicationEvent)new DocumentPublishedEvent(this, document.getDocumentId(), message));
        return document;
    }

    @Override
    public Document approve(DocumentId documentId, String message) throws DocumentNotFoundException {
        Document document = this.getDocument(documentId);
        if (!document.getStatus().equals((Object)Status.PUBLISHED)) {
            document.publish();
            this.publisher.publishEvent((ApplicationEvent)new DocumentPublishedEvent(this, document.getDocumentId(), message));
        }
        document.approve();
        this.publisher.publishEvent((ApplicationEvent)new DocumentApprovedEvent(this, document.getDocumentId(), message));
        return document;
    }

    @Override
    public Document edit(DocumentId documentId) throws DocumentNotFoundException, DocumentNotEditableException {
        Document document = this.getDocument(documentId);
        if (document.getStatus().equals((Object)Status.APPROVED)) {
            throw new DocumentNotEditableException(document);
        }
        document.edit();
        this.publisher.publishEvent((ApplicationEvent)new DocumentEditingEvent(this, document));
        return document;
    }

    private Document getDocument(DocumentId documentId) throws DocumentNotFoundException {
        Document document = (Document)this.documentRepository.findOne((Serializable)((Object)documentId.getId()));
        if (document == null) {
            throw new DocumentNotFoundException(documentId);
        }
        return document;
    }

    @Override
    public Document findBy(DocumentId documentId) throws DocumentNotFoundException {
        Validate.notNull((Object)documentId);
        Document document = (Document)this.documentRepository.findOne((Serializable)((Object)documentId.getId()));
        if (document == null) {
            throw new DocumentNotFoundException(documentId);
        }
        return document;
    }

    @Override
    public List<Document> findBy(TemplateId documentId) throws TemplateNotFoundException {
        Template template = this.templateDomainService.findBy(documentId);
        return this.documentRepository.findBy(template);
    }

    @Override
    public Page<Document> findBy(TenantId tenantId, Pageable pageable, String searchBy) {
        Validate.notNull((Object)tenantId);
        DocumentTenantSpecification tenantSpec = new DocumentTenantSpecification(tenantId.getId());
        Specifications specifications = Specifications.where((Specification)tenantSpec);
        if (!StringUtils.isEmpty((CharSequence)searchBy)) {
            specifications = specifications.and((Specification)new DocumentSearchBySpecification(searchBy));
        }
        return this.documentRepository.findAll((Specification)specifications, pageable);
    }

    @Override
    public Page<Document> findBy(TenantId tenantId, Pageable pageable, ProjectId projectId, String searchBy) throws ProjectNotFoundException {
        Validate.notNull((Object)tenantId);
        Validate.notNull((Object)projectId);
        DocumentTenantSpecification tenantSpec = new DocumentTenantSpecification(tenantId.getId());
        Specifications specifications = Specifications.where((Specification)tenantSpec);
        List projectVersions = this.projectDomainQueryService.findAllVersionsBy(projectId);
        specifications = specifications.and((Specification)new DocumentProjectVersionsSpecification(projectVersions));
        if (!StringUtils.isEmpty((CharSequence)searchBy)) {
            specifications = specifications.and((Specification)new DocumentSearchBySpecification(searchBy));
        }
        return this.documentRepository.findAll((Specification)specifications, pageable);
    }

    @Override
    public Page<Document> findBy(TenantId tenantId, Pageable pageable, ProjectVersionId projectVersionId, String searchBy) {
        Validate.notNull((Object)tenantId);
        DocumentTenantSpecification tenantSpec = new DocumentTenantSpecification(tenantId.getId());
        Specifications specifications = Specifications.where((Specification)tenantSpec);
        specifications = specifications.and((Specification)new DocumentProjectVersionSpecification(projectVersionId));
        if (!StringUtils.isEmpty((CharSequence)searchBy)) {
            specifications = specifications.and((Specification)new DocumentSearchBySpecification(searchBy));
        }
        return this.documentRepository.findAll((Specification)specifications, pageable);
    }

    @Override
    public Set<Template> findUsedTemplates(ProjectVersionId projectVersionId) {
        return this.documentRepository.findUsedTemplates(projectVersionId.getId());
    }

    @Override
    public DocumentRevision getRevision(DocumentId documentId) throws DocumentNotFoundException {
        try {
            Document document = this.findBy(documentId);
            ProjectVersion projectVersion = this.projectDomainQueryService.findVersionBy(document.getProjectVersionId());
            Tenant tenant = this.tenantQueryService.find(document.getTenantId());
            return new DocumentRevision(projectVersion, document, tenant.getAvatarId());
        }
        catch (TenantNotFoundException | ProjectVersionNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<SectionContent> findSectionContentsBy(TenantId tenantId, DocumentId documentId) throws DocumentNotFoundException, TemplateNotFoundException {
        Document document = this.findBy(documentId);
        List<SectionTemplate> sectionTemplates = this.sectionTemplateRepository.findBy(document);
        ArrayList<SectionContent> result = new ArrayList<SectionContent>(sectionTemplates.size());
        for (SectionTemplate sectionTemplate : sectionTemplates) {
            result.add(sectionTemplate.getSectionContent(document, this.sectionContentBuilder));
        }
        return result;
    }

    @Override
    public PersistedTextSectionContent updateTextSection(DocumentId documentId, SectionTemplateId sectionTemplateId, String text) throws DocumentNotFoundException, SectionTemplateNotFoundException {
        SectionTemplate sectionTemplate;
        Document document = this.findBy(documentId);
        PersistedTextSectionContent section = (PersistedTextSectionContent)this.persistedSectionContentRepository.findBy(document, sectionTemplate = this.templateDomainService.findSectionTemplateBy(sectionTemplateId));
        if (section == null) {
            section = new PersistedTextSectionContent(document, sectionTemplate);
        }
        section.setText(text);
        String message = String.format("Section %s updated", sectionTemplate.getName());
        this.publisher.publishEvent((ApplicationEvent)new TextSectionUpdatedEvent(this, document.getProjectId(), documentId, sectionTemplateId, message, text));
        return (PersistedTextSectionContent)this.persistedSectionContentRepository.save(section);
    }
}

