/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.document;

import com.clusterra.iam.core.application.tenant.TenantNotFoundException;
import com.clusterra.iam.core.application.tenant.TenantQueryService;
import com.clusterra.iam.core.domain.model.tenant.Tenant;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentRevision;
import com.clusterra.pmbok.document.domain.model.document.section.PersistedSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.history.HistorySectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.reference.ReferenceSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.repo.PersistedSectionContentRepository;
import com.clusterra.pmbok.document.domain.model.document.section.term.TermSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.text.EmptyTextSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.text.PersistedTextSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.text.TextSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.title.TitleSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.toc.TocSectionContent;
import com.clusterra.pmbok.document.domain.model.history.HistoryEntry;
import com.clusterra.pmbok.document.domain.model.history.repo.HistoryEntryRepository;
import com.clusterra.pmbok.document.domain.model.reference.repo.ReferenceAssociationRepository;
import com.clusterra.pmbok.document.domain.model.template.repo.SectionTemplateRepository;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplate;
import com.clusterra.pmbok.document.domain.model.term.repo.TermAssociationRepository;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.document.SectionContentBuilder;
import com.clusterra.pmbok.project.domain.model.Project;
import com.clusterra.pmbok.project.domain.service.ProjectDomainQueryService;
import com.clusterra.pmbok.project.domain.service.ProjectNotFoundException;
import com.clusterra.pmbok.reference.domain.model.reference.Reference;
import com.clusterra.pmbok.term.domain.model.term.Term;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.MANDATORY)
public class SectionContentBuilderImpl
implements SectionContentBuilder {
    @Autowired
    private PersistedSectionContentRepository<PersistedSectionContent> repository;
    @Autowired
    private DocumentDomainService documentDomainService;
    @Autowired
    private HistoryEntryRepository historyEntryRepository;
    @Autowired
    private ReferenceAssociationRepository referenceAssociationRepository;
    @Autowired
    private ProjectDomainQueryService projectDomainQueryService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private TermAssociationRepository termAssociationRepository;
    @Autowired
    private SectionTemplateRepository<SectionTemplate> sectionTemplateRepository;

    @Override
    public HistorySectionContent buildHistorySectionContent(Document document, SectionTemplate sectionTemplate) {
        Validate.notNull((Object)document);
        Validate.notNull((Object)sectionTemplate);
        List<HistoryEntry> entries = this.historyEntryRepository.findBy(document);
        return new HistorySectionContent(document.getDocumentId(), entries, sectionTemplate);
    }

    @Override
    public ReferenceSectionContent buildReferenceSectionContent(Document document, SectionTemplate sectionTemplate) {
        Validate.notNull((Object)document);
        Validate.notNull((Object)sectionTemplate);
        List<Reference> references = this.referenceAssociationRepository.findBy(document.getTenantId().getId(), document);
        return new ReferenceSectionContent(document.getDocumentId(), sectionTemplate, references);
    }

    @Override
    public TermSectionContent buildTermSectionContent(Document document, SectionTemplate sectionTemplate) {
        Validate.notNull((Object)document);
        Validate.notNull((Object)sectionTemplate);
        List<Term> terms = this.termAssociationRepository.findBy(document.getTenantId().getId(), document);
        return new TermSectionContent(document.getDocumentId(), sectionTemplate, terms);
    }

    @Override
    public TextSectionContent buildTextSectionContent(Document document, SectionTemplate sectionTemplate) {
        Validate.notNull((Object)document);
        Validate.notNull((Object)sectionTemplate);
        PersistedTextSectionContent content = (PersistedTextSectionContent)this.repository.findBy(document, sectionTemplate);
        return content != null ? content : new EmptyTextSectionContent(document.getDocumentId(), sectionTemplate);
    }

    @Override
    public TitleSectionContent buildTitleSectionContent(Document document, SectionTemplate sectionTemplate) {
        Validate.notNull((Object)document);
        Validate.notNull((Object)sectionTemplate);
        try {
            DocumentRevision revision = this.documentDomainService.getRevision(document.getDocumentId());
            Project project = this.projectDomainQueryService.findBy(document.getProjectId());
            Tenant tenant = this.tenantQueryService.find(document.getTenantId());
            return new TitleSectionContent(sectionTemplate, document.getDocumentId(), project.getName(), tenant.getAvatarId(), revision, document.getModifiedByUserId());
        }
        catch (TenantNotFoundException | DocumentNotFoundException | ProjectNotFoundException e) {
            throw new RuntimeException((Throwable)e);
        }
    }

    @Override
    public TocSectionContent buildTocSectionContent(Document document, SectionTemplate sectionTemplate) {
        Validate.notNull((Object)document);
        Validate.notNull((Object)sectionTemplate);
        List<SectionTemplate> sectionTemplates = this.sectionTemplateRepository.findBy(document);
        return new TocSectionContent(sectionTemplate, document.getDocumentId(), sectionTemplates);
    }
}

