/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.document.listen;

import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.event.TemplateDeletingEvent;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.listen.TemplateUsedException;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TemplateDeletingEvent4DocumentListener
implements ApplicationListener<TemplateDeletingEvent> {
    @Autowired
    private DocumentDomainService documentDomainService;

    @Transactional(propagation=Propagation.MANDATORY)
    public void onApplicationEvent(TemplateDeletingEvent event) {
        List<DocumentId> documentIds = this.getDocumentIds(event.getTemplateId());
        if (!documentIds.isEmpty()) {
            throw new TemplateUsedException(event.getTemplateId(), documentIds);
        }
    }

    private List<DocumentId> getDocumentIds(TemplateId templateId) {
        try {
            List<Document> documents = this.documentDomainService.findBy(templateId);
            ArrayList<DocumentId> documentIds = new ArrayList<DocumentId>(documents.size());
            if (!documents.isEmpty()) {
                for (Document document : documents) {
                    documentIds.add(document.getDocumentId());
                }
            }
            return documentIds;
        }
        catch (TemplateNotFoundException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }
}

