/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.history;

import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.history.HistoryEntry;
import com.clusterra.pmbok.document.domain.model.history.repo.HistoryEntryRepository;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.history.HistoryEntryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.MANDATORY)
public class HistoryEntryServiceImpl
implements HistoryEntryService {
    @Autowired
    private HistoryEntryRepository repository;
    @Autowired
    private DocumentDomainService documentDomainService;

    @Override
    public HistoryEntry addHistoryEntry(DocumentId documentId, String comment) throws DocumentNotFoundException {
        Document document = this.documentDomainService.findBy(documentId);
        HistoryEntry entry = new HistoryEntry(document, this.documentDomainService.getRevision(documentId).getRevision(), comment);
        return (HistoryEntry)this.repository.save(entry);
    }

    @Override
    public void deleteBy(DocumentId documentId) throws DocumentNotFoundException {
        Document document = this.documentDomainService.findBy(documentId);
        this.repository.deleteBy(document);
    }

    @Override
    public List<HistoryEntry> findBy(DocumentId documentId) throws DocumentNotFoundException {
        Document document = this.documentDomainService.findBy(documentId);
        return this.repository.findBy(document);
    }
}

