/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.reference;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.reference.ReferenceAssociation;
import com.clusterra.pmbok.document.domain.model.reference.repo.ReferenceAssociationRepository;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.reference.ReferenceAssociationService;
import com.clusterra.pmbok.reference.domain.model.reference.Reference;
import com.clusterra.pmbok.reference.domain.model.reference.ReferenceId;
import com.clusterra.pmbok.reference.domain.model.reference.repo.ReferenceRepository;
import com.clusterra.pmbok.reference.domain.service.ReferenceNotFoundException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.MANDATORY)
public class ReferenceAssociationServiceImpl
implements ReferenceAssociationService {
    @Autowired
    private DocumentDomainService documentDomainService;
    @Autowired
    private ReferenceRepository referenceRepository;
    @Autowired
    private ReferenceAssociationRepository referenceAssociationRepository;

    @Override
    public void createAssociation(TenantId tenantId, DocumentId documentId, ReferenceId referenceId) throws ReferenceNotFoundException, DocumentNotFoundException {
        Validate.notNull((Object)documentId);
        Validate.notNull((Object)referenceId);
        Document document = this.documentDomainService.findBy(documentId);
        Reference reference = (Reference)this.referenceRepository.findOne((Serializable)((Object)referenceId.getId()));
        if (reference == null) {
            throw new ReferenceNotFoundException(referenceId);
        }
        ReferenceAssociation association = this.referenceAssociationRepository.findBy(tenantId.getId(), referenceId.getId(), document);
        if (association == null) {
            this.referenceAssociationRepository.save(new ReferenceAssociation(tenantId, reference.getReferenceId(), document));
        }
    }

    @Override
    public void deleteAssociation(TenantId tenantId, DocumentId documentId, ReferenceId referenceId) throws ReferenceNotFoundException, DocumentNotFoundException {
        Validate.notNull((Object)documentId);
        Validate.notNull((Object)referenceId);
        Document document = this.documentDomainService.findBy(documentId);
        Reference reference = (Reference)this.referenceRepository.findOne((Serializable)((Object)referenceId.getId()));
        if (reference == null) {
            throw new ReferenceNotFoundException(referenceId);
        }
        ReferenceAssociation association = this.referenceAssociationRepository.findBy(tenantId.getId(), referenceId.getId(), document);
        if (association != null) {
            this.referenceAssociationRepository.delete(association);
        }
    }

    @Override
    public void deleteAllAssociations(TenantId tenantId, DocumentId documentId) throws DocumentNotFoundException {
        Validate.notNull((Object)documentId);
        Document document = this.documentDomainService.findBy(documentId);
        this.referenceAssociationRepository.deleteBy(tenantId.getId(), document);
    }

    @Override
    public Page<Reference> findBy(TenantId tenantId, Pageable pageable, DocumentId documentId, String searchBy) throws DocumentNotFoundException {
        Validate.notNull((Object)tenantId);
        Validate.notNull((Object)documentId);
        Document document = this.documentDomainService.findBy(documentId);
        if (!StringUtils.isEmpty((CharSequence)searchBy)) {
            return this.referenceAssociationRepository.findBy(pageable, tenantId.getId(), document, "%" + searchBy + "%");
        }
        return this.referenceAssociationRepository.findBy(pageable, document);
    }

    @Override
    public List<Reference> findBy(TenantId tenantId, DocumentId documentId) throws DocumentNotFoundException {
        Validate.notNull((Object)tenantId);
        Document document = this.documentDomainService.findBy(documentId);
        return this.referenceAssociationRepository.findBy(tenantId.getId(), document);
    }
}

