/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.reference.listen;

import com.clusterra.iam.core.application.user.UserNotFoundException;
import com.clusterra.iam.core.application.user.UserQueryService;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.event.DocumentCreatedEvent;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.reference.ReferenceAssociationService;
import com.clusterra.pmbok.reference.domain.model.reference.Reference;
import com.clusterra.pmbok.reference.domain.service.ReferenceDomainService;
import com.clusterra.pmbok.reference.domain.service.ReferenceNotFoundException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DocumentCreatedEvent4ReferenceListener
implements ApplicationListener<DocumentCreatedEvent> {
    @Autowired
    private ReferenceDomainService referenceDomainService;
    @Autowired
    private ReferenceAssociationService referenceAssociationService;
    @Autowired
    private DocumentDomainService documentDomainService;
    @Autowired
    private UserQueryService userQueryService;

    @Transactional(propagation=Propagation.MANDATORY)
    public void onApplicationEvent(DocumentCreatedEvent event) {
        try {
            String author = this.userQueryService.findUser(event.getCreatedByUserId()).getPerson().getDisplayName();
            String revision = this.documentDomainService.getRevision(event.getDocumentId()).getRevision();
            Document document = this.documentDomainService.findBy(event.getDocumentId());
            String name = document.getTemplate().getName();
            Reference reference = this.referenceDomainService.create(event.getTenantId(), revision, name, new Date(), author);
            this.referenceAssociationService.createAssociation(event.getTenantId(), event.getDocumentId(), reference.getReferenceId());
        }
        catch (UserNotFoundException | DocumentNotFoundException | ReferenceNotFoundException e) {
            throw new RuntimeException((Throwable)e);
        }
    }
}

