/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.reference.listen;

import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.domain.model.document.event.DocumentDeletingEvent;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.reference.ReferenceAssociationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DocumentDeletingEvent4ReferenceListener
implements ApplicationListener<DocumentDeletingEvent> {
    @Autowired
    private ReferenceAssociationService service;
    @Autowired
    private IdentityTracker identityTracker;

    @Transactional(propagation=Propagation.MANDATORY)
    public void onApplicationEvent(DocumentDeletingEvent event) {
        try {
            this.service.deleteAllAssociations(this.identityTracker.currentTenant(), event.getDocumentId());
        }
        catch (NotAuthenticatedException | DocumentNotFoundException e) {
            throw new RuntimeException((Throwable)e);
        }
    }
}

