/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.template;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionType;
import com.clusterra.pmbok.document.domain.service.template.TemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface TemplateDomainService {
    public Template createTemplate(TenantId var1, Integer var2, Integer var3, String var4) throws TemplateAlreadyExistsException;

    public Template updateTemplateName(TemplateId var1, String var2) throws TemplateNotFoundException;

    public void deleteTemplate(TemplateId var1) throws TemplateNotFoundException;

    public SectionTemplate addHistorySection(TemplateId var1, String var2) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException;

    public SectionTemplate addReferenceSection(TemplateId var1, String var2) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException;

    public SectionTemplate addTermSection(TemplateId var1, String var2) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException;

    public SectionTemplate addTextSection(TemplateId var1, String var2) throws TemplateNotFoundException;

    public SectionTemplate addTitleSection(TemplateId var1, String var2) throws TemplateNotFoundException;

    public SectionTemplate addTocSection(TemplateId var1, String var2) throws TemplateNotFoundException;

    public void removeSection(TemplateId var1, SectionTemplateId var2) throws TemplateNotFoundException, SectionTemplateNotFoundException;

    public SectionTemplate updateSectionOrder(TemplateId var1, SectionTemplateId var2, Integer var3) throws SectionTemplateNotFoundException, TemplateNotFoundException;

    public SectionTemplate updateSectionName(TemplateId var1, SectionTemplateId var2, String var3) throws TemplateNotFoundException, SectionTemplateNotFoundException;

    public SectionTemplate findSectionTemplateBy(SectionTemplateId var1) throws SectionTemplateNotFoundException;

    public List<SectionTemplate> findSectionTemplates(TemplateId var1) throws TemplateNotFoundException;

    public Template findBy(TemplateId var1) throws TemplateNotFoundException;

    public Template findByName(TenantId var1, String var2);

    public Page<Template> findBy(TenantId var1, Pageable var2, String var3);

    public List<Template> findAllTemplates(TenantId var1);

    public void markReady(TemplateId var1) throws TemplateNotFoundException;

    public Set<SectionType> findSectionTypesUsedBy(TemplateId var1) throws TemplateNotFoundException;
}

