/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.template;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.pmbok.document.domain.model.document.Version;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.event.TemplateCreatedEvent;
import com.clusterra.pmbok.document.domain.model.template.event.TemplateDeletedEvent;
import com.clusterra.pmbok.document.domain.model.template.event.TemplateDeletingEvent;
import com.clusterra.pmbok.document.domain.model.template.event.TemplateUpdatedEvent;
import com.clusterra.pmbok.document.domain.model.template.repo.SectionTemplateRepository;
import com.clusterra.pmbok.document.domain.model.template.repo.TemplateRepository;
import com.clusterra.pmbok.document.domain.model.template.repo.TemplateSearchBySpecification;
import com.clusterra.pmbok.document.domain.model.template.repo.TemplateTenantSpecification;
import com.clusterra.pmbok.document.domain.model.template.section.ReferenceSectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionType;
import com.clusterra.pmbok.document.domain.model.template.section.TextSectionTemplate;
import com.clusterra.pmbok.document.domain.service.template.TemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.template.TemplateDomainService;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.MANDATORY)
public class TemplateDomainServiceImpl
implements TemplateDomainService {
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private SectionTemplateRepository<SectionTemplate> sectionTemplateRepository;
    @Autowired
    private ApplicationEventPublisher publisher;

    @Override
    public Template createTemplate(TenantId tenantId, Integer majorVersion, Integer minorVersion, String name) throws TemplateAlreadyExistsException {
        Validate.notNull((Object)tenantId);
        Validate.notNull((Object)majorVersion);
        Validate.notNull((Object)minorVersion);
        Validate.notNull((Object)name);
        Validate.inclusiveBetween((Object)0, (Object)100, (Comparable)majorVersion);
        Validate.inclusiveBetween((Object)0, (Object)100, (Comparable)minorVersion);
        Version version = new Version(majorVersion, minorVersion);
        Template existing = this.templateRepository.findByTenantIdByName(tenantId.getId(), name);
        if (existing != null) {
            throw new TemplateAlreadyExistsException(tenantId, name);
        }
        Template template = (Template)this.templateRepository.save(new Template(tenantId, version, name));
        this.publisher.publishEvent((ApplicationEvent)new TemplateCreatedEvent(this, template.getTemplateId()));
        return template;
    }

    @Override
    public Template updateTemplateName(TemplateId templateId, String name) throws TemplateNotFoundException {
        Validate.notNull((Object)name);
        Validate.notNull((Object)((Object)templateId));
        Template template = this.findDocumentTemplate(templateId);
        template.setName(name);
        this.templateRepository.save(template);
        return template;
    }

    @Override
    public void deleteTemplate(TemplateId templateId) throws TemplateNotFoundException {
        Validate.notNull((Object)((Object)templateId));
        Template template = this.findDocumentTemplate(templateId);
        this.publisher.publishEvent((ApplicationEvent)new TemplateDeletingEvent(this, template.getTemplateId()));
        template.removeAllSections(this.sectionTemplateRepository);
        this.templateRepository.delete(template);
        this.publisher.publishEvent((ApplicationEvent)new TemplateDeletedEvent(this, template.getTemplateId()));
    }

    @Override
    public Template findBy(TemplateId templateId) throws TemplateNotFoundException {
        return this.findDocumentTemplate(templateId);
    }

    @Override
    public Template findByName(TenantId tenantId, String name) {
        Validate.notNull((Object)tenantId);
        return this.templateRepository.findByTenantIdByName(tenantId.getId(), name);
    }

    @Override
    public Page<Template> findBy(TenantId tenantId, Pageable pageable, String searchBy) {
        Validate.notNull((Object)tenantId);
        TemplateTenantSpecification tenantSpec = new TemplateTenantSpecification(tenantId.getId());
        Specifications specifications = Specifications.where((Specification)tenantSpec);
        if (!StringUtils.isEmpty((CharSequence)searchBy)) {
            specifications = specifications.and((Specification)new TemplateSearchBySpecification(searchBy));
        }
        return this.templateRepository.findAll((Specification)specifications, pageable);
    }

    @Override
    public List<Template> findAllTemplates(TenantId tenantId) {
        Validate.notNull((Object)tenantId);
        return this.templateRepository.findByTenantId(tenantId.getId());
    }

    @Override
    public void markReady(TemplateId templateId) throws TemplateNotFoundException {
        Template template = this.findDocumentTemplate(templateId);
        template.markReady();
    }

    @Override
    public Set<SectionType> findSectionTypesUsedBy(TemplateId templateId) throws TemplateNotFoundException {
        Template template = this.findDocumentTemplate(templateId);
        return this.sectionTemplateRepository.findSectionTypesUsedBy(template);
    }

    private Template findDocumentTemplate(TemplateId templateId) throws TemplateNotFoundException {
        Validate.notNull((Object)((Object)templateId));
        Template template = (Template)this.templateRepository.findOne((Serializable)((Object)templateId.getId()));
        if (template == null) {
            throw new TemplateNotFoundException(templateId);
        }
        return template;
    }

    @Override
    public SectionTemplate addTextSection(TemplateId templateId, String name) throws TemplateNotFoundException {
        Template template = this.findDocumentTemplate(templateId);
        TextSectionTemplate textSection = template.addTextSection(name, this.sectionTemplateRepository);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
        return textSection;
    }

    @Override
    public SectionTemplate addTitleSection(TemplateId templateId, String name) throws TemplateNotFoundException {
        Template template = this.findDocumentTemplate(templateId);
        SectionTemplate textSection = template.addTitleSection(name, this.sectionTemplateRepository);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
        return textSection;
    }

    @Override
    public SectionTemplate addTocSection(TemplateId templateId, String name) throws TemplateNotFoundException {
        Template template = this.findDocumentTemplate(templateId);
        SectionTemplate textSection = template.addTocSection(name, this.sectionTemplateRepository);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
        return textSection;
    }

    @Override
    public SectionTemplate findSectionTemplateBy(SectionTemplateId sectionTemplateId) throws SectionTemplateNotFoundException {
        SectionTemplate sectionTemplate = (SectionTemplate)this.sectionTemplateRepository.findOne((Serializable)((Object)sectionTemplateId.getId()));
        if (sectionTemplate == null) {
            throw new SectionTemplateNotFoundException(sectionTemplateId);
        }
        return sectionTemplate;
    }

    @Override
    public SectionTemplate addHistorySection(TemplateId templateId, String name) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException {
        Template template = this.findDocumentTemplate(templateId);
        SectionTemplate historySection = template.addHistorySection(name, this.sectionTemplateRepository);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
        return historySection;
    }

    @Override
    public SectionTemplate addTermSection(TemplateId templateId, String name) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException {
        Template template = this.findDocumentTemplate(templateId);
        SectionTemplate termSection = template.addTermSection(name, this.sectionTemplateRepository);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
        return termSection;
    }

    @Override
    public SectionTemplate addReferenceSection(TemplateId templateId, String name) throws TemplateNotFoundException, SectionTemplateAlreadyExistsException {
        Template template = this.findDocumentTemplate(templateId);
        ReferenceSectionTemplate referenceSection = template.addReferenceSection(name, this.sectionTemplateRepository);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
        return referenceSection;
    }

    @Override
    public void removeSection(TemplateId templateId, SectionTemplateId sectionTemplateId) throws TemplateNotFoundException, SectionTemplateNotFoundException {
        Template template = this.findDocumentTemplate(templateId);
        template.removeSection(sectionTemplateId, this.sectionTemplateRepository);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
    }

    @Override
    public List<SectionTemplate> findSectionTemplates(TemplateId templateId) throws TemplateNotFoundException {
        Template template = this.findDocumentTemplate(templateId);
        return this.sectionTemplateRepository.findBy(template);
    }

    @Override
    public SectionTemplate updateSectionOrder(TemplateId templateId, SectionTemplateId sectionTemplateId, Integer orderIndex) throws SectionTemplateNotFoundException, TemplateNotFoundException {
        Template template = this.findDocumentTemplate(templateId);
        SectionTemplate setOrder = template.setOrder(sectionTemplateId, orderIndex, this.sectionTemplateRepository);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
        return setOrder;
    }

    @Override
    public SectionTemplate updateSectionName(TemplateId templateId, SectionTemplateId sectionTemplateId, String name) throws TemplateNotFoundException, SectionTemplateNotFoundException {
        SectionTemplate sectionTemplate = (SectionTemplate)this.sectionTemplateRepository.findOne((Serializable)((Object)sectionTemplateId.getId()));
        if (sectionTemplate == null) {
            throw new SectionTemplateNotFoundException(sectionTemplateId);
        }
        sectionTemplate.setName(name);
        this.publisher.publishEvent((ApplicationEvent)new TemplateUpdatedEvent(this, templateId));
        return sectionTemplate;
    }
}

