/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.document.domain.service.term;

import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.term.TermAssociation;
import com.clusterra.pmbok.document.domain.model.term.repo.TermAssociationRepository;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.term.TermAssociationService;
import com.clusterra.pmbok.term.domain.model.term.Term;
import com.clusterra.pmbok.term.domain.model.term.TermId;
import com.clusterra.pmbok.term.domain.model.term.repo.TermRepository;
import com.clusterra.pmbok.term.domain.service.TermNotFoundException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.MANDATORY)
public class TermAssociationServiceImpl
implements TermAssociationService {
    @Autowired
    private TermRepository termRepository;
    @Autowired
    private TermAssociationRepository termAssociationRepository;
    @Autowired
    private DocumentDomainService documentDomainService;

    @Override
    public void createAssociation(TenantId tenantId, DocumentId documentId, TermId termId) throws DocumentNotFoundException, TermNotFoundException {
        Validate.notNull((Object)documentId);
        Validate.notNull((Object)termId);
        Document document = this.documentDomainService.findBy(documentId);
        Term term = (Term)this.termRepository.findOne((Serializable)((Object)termId.getId()));
        if (term == null) {
            throw new TermNotFoundException(termId);
        }
        TermAssociation association = this.termAssociationRepository.findBy(tenantId.getId(), termId.getId(), document);
        if (association == null) {
            this.termAssociationRepository.save(new TermAssociation(tenantId, termId.getId(), document));
        }
    }

    @Override
    public void deleteAssociation(TenantId tenantId, DocumentId documentId, TermId termId) throws DocumentNotFoundException, TermNotFoundException {
        Validate.notNull((Object)documentId);
        Validate.notNull((Object)termId);
        Document document = this.documentDomainService.findBy(documentId);
        Term term = (Term)this.termRepository.findOne((Serializable)((Object)termId.getId()));
        if (term == null) {
            throw new TermNotFoundException(termId);
        }
        TermAssociation association = this.termAssociationRepository.findBy(tenantId.getId(), termId.getId(), document);
        if (association != null) {
            this.termAssociationRepository.delete(association);
        }
    }

    @Override
    public void deleteAllAssociations(TenantId tenantId, DocumentId documentId) throws DocumentNotFoundException {
        Validate.notNull((Object)documentId);
        Document document = this.documentDomainService.findBy(documentId);
        this.termAssociationRepository.deleteBy(tenantId.getId(), document);
    }

    @Override
    public Page<Term> findBy(TenantId tenantId, Pageable pageable, DocumentId documentId, String searchBy) throws DocumentNotFoundException {
        Validate.notNull((Object)tenantId);
        Document document = this.documentDomainService.findBy(documentId);
        if (!StringUtils.isEmpty((CharSequence)searchBy)) {
            return this.termAssociationRepository.findBy(pageable, tenantId.getId(), document, "%" + searchBy + "%");
        }
        return this.termAssociationRepository.findBy(pageable, document);
    }

    @Override
    public List<Term> findBy(TenantId tenantId, DocumentId documentId) throws DocumentNotFoundException {
        Validate.notNull((Object)tenantId);
        Document document = this.documentDomainService.findBy(documentId);
        return this.termAssociationRepository.findBy(tenantId.getId(), document);
    }
}

