/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.document;

import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.application.document.DocumentCommandService;
import com.clusterra.pmbok.document.application.document.DocumentQueryService;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.document.section.SectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.text.PersistedTextSectionContent;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.service.document.DocumentAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotEditableException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import com.clusterra.pmbok.project.domain.model.ProjectId;
import com.clusterra.pmbok.project.domain.model.ProjectVersionId;
import com.clusterra.pmbok.project.domain.service.ProjectNotFoundException;
import com.clusterra.pmbok.project.domain.service.ProjectVersionNotFoundException;
import com.clusterra.pmbok.reference.domain.model.reference.ReferenceId;
import com.clusterra.pmbok.reference.domain.service.ReferenceNotFoundException;
import com.clusterra.pmbok.rest.document.CommentPod;
import com.clusterra.pmbok.rest.document.DocumentPod;
import com.clusterra.pmbok.rest.document.TextPod;
import com.clusterra.pmbok.rest.document.resource.DocumentResource;
import com.clusterra.pmbok.rest.document.resource.DocumentResourceAssembler;
import com.clusterra.pmbok.rest.document.resource.SectionResource;
import com.clusterra.pmbok.rest.document.resource.SectionResourceAssembler;
import com.clusterra.pmbok.term.domain.model.term.TermId;
import com.clusterra.pmbok.term.domain.service.TermNotFoundException;
import com.clusterra.rest.util.ResponseMessage;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ExposesResourceFor(value=Document.class)
@RequestMapping(value={"pmbok/documents"}, produces={"application/json"})
public class DocumentController {
    @Autowired
    private DocumentCommandService documentCommandService;
    @Autowired
    private DocumentQueryService documentQueryService;
    @Autowired
    private SectionResourceAssembler sectionResourceAssembler;
    @Autowired
    private DocumentResourceAssembler documentResourceAssembler;

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseEntity<DocumentResource> create(@Valid @RequestBody DocumentPod documentPod, BindingResult bindingResult) throws BindException, ProjectNotFoundException, DocumentAlreadyExistsException, ProjectVersionNotFoundException, NotAuthenticatedException, TemplateNotFoundException {
        if (bindingResult.hasErrors()) {
            throw new BindException(bindingResult);
        }
        Document document = this.documentCommandService.create(new ProjectVersionId(documentPod.getProjectVersionId()), new TemplateId(documentPod.getTemplateId()));
        return new ResponseEntity((Object)this.documentResourceAssembler.toResource(document), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<DocumentResource> get(@PathVariable String id) throws DocumentNotFoundException, DocumentNotEditableException {
        Document document = this.documentQueryService.findBy(new DocumentId(id));
        return new ResponseEntity((Object)this.documentResourceAssembler.toResource(document), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<DefaultMessageSourceResolvable> delete(@PathVariable String id) throws DocumentNotFoundException {
        this.documentCommandService.deleteBy(new DocumentId(id));
        return new ResponseEntity((Object)ResponseMessage.message("deleted"), HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{id}/publish"}, method={RequestMethod.PUT})
    public ResponseEntity<DocumentResource> publish(@PathVariable String id, @RequestBody CommentPod commentPod) throws DocumentNotFoundException, DocumentNotEditableException {
        Document document = this.documentCommandService.publish(new DocumentId(id), commentPod.getComment());
        return new ResponseEntity((Object)this.documentResourceAssembler.toResource(document), HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/{id}/approve"}, method={RequestMethod.PUT})
    public ResponseEntity<DocumentResource> approve(@PathVariable String id, @RequestBody CommentPod commentPod) throws DocumentNotFoundException, DocumentNotEditableException {
        Document document = this.documentCommandService.approve(new DocumentId(id), commentPod.getComment());
        return new ResponseEntity((Object)this.documentResourceAssembler.toResource(document), HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/{id}/edit"}, method={RequestMethod.PUT})
    public ResponseEntity<DocumentResource> edit(@PathVariable String id, @RequestBody CommentPod commentPod) throws DocumentNotFoundException, DocumentNotEditableException {
        Document document = this.documentCommandService.edit(new DocumentId(id));
        return new ResponseEntity((Object)this.documentResourceAssembler.toResource(document), HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public ResponseEntity<PagedResources<DocumentResource>> search(@PageableDefault Pageable pageable, @RequestParam(required=false) String projectId, @RequestParam(required=false) String projectVersionId, @RequestParam(required=false) String searchBy, PagedResourcesAssembler<Document> assembler) throws ProjectVersionNotFoundException, NotAuthenticatedException, ProjectNotFoundException {
        pageable = DocumentController.fixSorting(pageable);
        Page documents = !StringUtils.isEmpty((CharSequence)projectVersionId) ? this.documentQueryService.findBy(pageable, new ProjectVersionId(projectVersionId), searchBy) : (!StringUtils.isEmpty((CharSequence)projectId) ? this.documentQueryService.findBy(pageable, new ProjectId(projectId), searchBy) : this.documentQueryService.findBy(pageable, searchBy));
        PagedResources pagedResources = assembler.toResource(documents, (ResourceAssembler)this.documentResourceAssembler);
        return new ResponseEntity((Object)pagedResources, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/sections"}, method={RequestMethod.GET})
    public ResponseEntity<Resources<SectionResource>> sections(@PathVariable String id) throws DocumentNotFoundException, TemplateNotFoundException, NotAuthenticatedException {
        List sectionContents = this.documentQueryService.findSectionContents(new DocumentId(id));
        return new ResponseEntity((Object)new Resources((Iterable)this.sectionResourceAssembler.toResources(sectionContents), new Link[0]), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/terms/{termId}"}, method={RequestMethod.POST})
    public ResponseEntity<DefaultMessageSourceResolvable> associateTerm(@PathVariable String id, @PathVariable String termId) throws TermNotFoundException, NotAuthenticatedException, DocumentNotFoundException, SectionTemplateNotFoundException {
        this.documentCommandService.createAssociation(new DocumentId(id), new TermId(termId));
        return new ResponseEntity((Object)ResponseMessage.message("association created"), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}/terms/{termId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<DefaultMessageSourceResolvable> unAssociateTerm(@PathVariable String id, @PathVariable String termId) throws TermNotFoundException, NotAuthenticatedException, DocumentNotFoundException, SectionTemplateNotFoundException {
        this.documentCommandService.deleteAssociation(new DocumentId(id), new TermId(termId));
        return new ResponseEntity((Object)ResponseMessage.message("association removed"), HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{id}/references/{referenceId}"}, method={RequestMethod.POST})
    public ResponseEntity<DefaultMessageSourceResolvable> associateReference(@PathVariable String id, @PathVariable String referenceId) throws ReferenceNotFoundException, NotAuthenticatedException, DocumentNotFoundException, SectionTemplateNotFoundException {
        this.documentCommandService.createAssociation(new DocumentId(id), new ReferenceId(referenceId));
        return new ResponseEntity((Object)ResponseMessage.message("association created"), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}/references/{referenceId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<DefaultMessageSourceResolvable> unAssociateReference(@PathVariable String id, @PathVariable String referenceId) throws ReferenceNotFoundException, DocumentNotFoundException, NotAuthenticatedException, SectionTemplateNotFoundException {
        this.documentCommandService.deleteAssociation(new DocumentId(id), new ReferenceId(referenceId));
        return new ResponseEntity((Object)ResponseMessage.message("association removed"), HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{id}/sections/{sectionTemplateId}/update-text"}, method={RequestMethod.POST})
    public ResponseEntity<SectionResource> updateText(@PathVariable String id, @PathVariable String sectionTemplateId, @Valid @RequestBody TextPod textPod) throws DocumentNotFoundException, SectionTemplateNotFoundException {
        PersistedTextSectionContent persistedTextSectionContent = this.documentCommandService.updateTextSection(new DocumentId(id), new SectionTemplateId(sectionTemplateId), textPod.getText());
        return new ResponseEntity((Object)this.sectionResourceAssembler.toResource((SectionContent)persistedTextSectionContent), HttpStatus.OK);
    }

    private static Pageable fixSorting(Pageable pageable) {
        if (pageable.getSort() == null) {
            return pageable;
        }
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>(1);
        block8: for (Sort.Order order : pageable.getSort()) {
            switch (order.getProperty()) {
                case "documentType": {
                    orders.add(new Sort.Order(order.getDirection(), "template.name"));
                    continue block8;
                }
                case "documentId": {
                    orders.add(new Sort.Order(order.getDirection(), "id"));
                    continue block8;
                }
            }
            orders.add(order);
        }
        return new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(orders));
    }
}

