/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.document;

import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class DocumentExceptionHandler {
    @ExceptionHandler(value={DocumentNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="document not found")
    @ResponseBody
    public List<FieldError> handle(DocumentNotFoundException exception) {
        return Arrays.asList(new FieldError("document", "id", exception.getMessage()));
    }

    @ExceptionHandler(value={SectionTemplateNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<FieldError> handle(SectionTemplateNotFoundException exception) {
        return Arrays.asList(new FieldError("sectionTemplate", "id", exception.getMessage()));
    }
}

