/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.document.resource;

import com.clusterra.iam.core.application.user.UserNotFoundException;
import com.clusterra.iam.core.application.user.UserQueryService;
import com.clusterra.pmbok.document.application.document.DocumentQueryService;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentRevision;
import com.clusterra.pmbok.document.domain.model.document.Status;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.rest.document.DocumentController;
import com.clusterra.pmbok.rest.document.DocumentDownloadController;
import com.clusterra.pmbok.rest.document.resource.DocumentResource;
import com.clusterra.pmbok.rest.project.ProjectController;
import com.clusterra.rest.util.LinkWithMethodBuilder;
import com.clusterra.rest.util.RestMethods;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class DocumentResourceAssembler
extends ResourceAssemblerSupport<Document, DocumentResource> {
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DocumentQueryService documentQueryService;

    public DocumentResourceAssembler() {
        super(DocumentController.class, DocumentResource.class);
    }

    protected DocumentResource instantiateResource(Document entity) {
        try {
            String createdBy = this.userQueryService.findUser(entity.getCreatedByUserId()).getPerson().getDisplayName();
            String modifiedBy = this.userQueryService.findUser(entity.getModifiedByUserId()).getPerson().getDisplayName();
            String documentType = entity.getTemplate().getName();
            DocumentRevision revision = this.documentQueryService.getRevision(entity.getDocumentId());
            String status = this.getStatus(entity.getStatus());
            return new DocumentResource(entity.getDocumentId(), entity.getProjectVersionId(), entity.getProjectId(), status, entity.getCreatedDate(), createdBy, entity.getModifiedDate(), modifiedBy, documentType, revision);
        }
        catch (UserNotFoundException | DocumentNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String getStatus(Status status) {
        Locale locale = LocaleContextHolder.getLocale();
        switch (status) {
            case NEW: {
                return this.messageSource.getMessage("document.status.new", null, locale);
            }
            case EDITING: {
                return this.messageSource.getMessage("document.status.editing", null, locale);
            }
            case PUBLISHED: {
                return this.messageSource.getMessage("document.status.published", null, locale);
            }
            case APPROVED: {
                return this.messageSource.getMessage("document.status.approved", null, locale);
            }
        }
        throw new IllegalArgumentException("unknown status " + status);
    }

    public DocumentResource toResource(Document document) {
        try {
            DocumentResource resource = (DocumentResource)this.createResourceWithId(document.getDocumentId(), document);
            resource.add(LinkWithMethodBuilder.linkWithMethodDelete(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).delete(document.getDocumentId().getId())).withRel(RestMethods.DELETE.getName())));
            resource.add(ControllerLinkBuilder.linkTo(((ProjectController)ControllerLinkBuilder.methodOn(ProjectController.class, (Object[])new Object[0])).get(document.getProjectId().getId())).withRel("pmbok.project"));
            resource.add(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).sections(document.getDocumentId().getId())).withRel("pmbok.document.sections"));
            if (!document.getStatus().equals((Object)Status.PUBLISHED)) {
                resource.add(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).publish(document.getDocumentId().getId(), null)).withRel("pmbok.document.publish"));
            }
            if (!document.getStatus().equals((Object)Status.APPROVED)) {
                resource.add(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).approve(document.getDocumentId().getId(), null)).withRel("pmbok.document.approve"));
            }
            resource.add(ControllerLinkBuilder.linkTo(((DocumentDownloadController)ControllerLinkBuilder.methodOn(DocumentDownloadController.class, (Object[])new Object[0])).download(document.getDocumentId().getId())).withRel("pmbok.document.download"));
            resource.add(ControllerLinkBuilder.linkTo(((ProjectController)ControllerLinkBuilder.methodOn(ProjectController.class, (Object[])new Object[0])).getVersion(document.getProjectVersionId().getId())).withRel("pmbok.document.version"));
            return resource;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

