/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.document.resource;

import com.clusterra.iam.core.application.user.UserId;
import com.clusterra.iam.core.application.user.UserNotFoundException;
import com.clusterra.iam.core.application.user.UserQueryService;
import com.clusterra.pmbok.document.application.document.DocumentQueryService;
import com.clusterra.pmbok.document.domain.model.document.DocumentRevision;
import com.clusterra.pmbok.document.domain.model.history.HistoryEntry;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.rest.document.DocumentController;
import com.clusterra.pmbok.rest.document.resource.HistoryEntryResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class HistoryEntryResourceAssembler
extends ResourceAssemblerSupport<HistoryEntry, HistoryEntryResource> {
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private DocumentQueryService documentQueryService;

    public HistoryEntryResourceAssembler() {
        super(DocumentController.class, HistoryEntryResource.class);
    }

    protected HistoryEntryResource instantiateResource(HistoryEntry entity) {
        try {
            String createdBy = this.userQueryService.findUser(new UserId(entity.getCreatedByUserId())).getPerson().getDisplayName();
            DocumentRevision documentRevision = this.documentQueryService.getRevision(entity.getDocument().getDocumentId());
            return new HistoryEntryResource(documentRevision, entity.getCreatedDate(), createdBy, entity.getComment());
        }
        catch (UserNotFoundException | DocumentNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public HistoryEntryResource toResource(HistoryEntry entity) {
        return this.instantiateResource(entity);
    }
}

