/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.document.resource;

import com.clusterra.pmbok.document.domain.model.document.section.SectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.SectionContentVisitor;
import com.clusterra.pmbok.document.domain.model.document.section.history.HistorySectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.reference.ReferenceSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.term.TermSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.text.TextSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.title.TitleSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.toc.TocSectionContent;
import com.clusterra.pmbok.rest.document.DocumentController;
import com.clusterra.pmbok.rest.document.resource.HistoryEntryResourceAssembler;
import com.clusterra.pmbok.rest.document.resource.SectionResource;
import com.clusterra.pmbok.rest.document.resource.TitleSectionResourceAssembler;
import com.clusterra.pmbok.rest.reference.ReferenceController;
import com.clusterra.pmbok.rest.reference.resource.ReferenceResourceAssembler;
import com.clusterra.pmbok.rest.term.TermController;
import com.clusterra.pmbok.rest.term.resource.TermResourceAssembler;
import com.clusterra.rest.util.LinkWithMethodBuilder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class SectionResourceAssembler
extends ResourceAssemblerSupport<SectionContent, SectionResource>
implements SectionContentVisitor<SectionResource> {
    @Autowired
    private HistoryEntryResourceAssembler historyEntryResourceAssembler;
    @Autowired
    private TitleSectionResourceAssembler titleSectionResourceAssembler;

    public SectionResourceAssembler() {
        super(DocumentController.class, SectionResource.class);
    }

    protected SectionResource instantiateResource(SectionContent entity) {
        String title = entity.getSectionTemplate().getTitle();
        return new SectionResource(entity.getSectionTemplate().getSectionTemplateId().getId(), entity.getSectionTemplate().getType(), title);
    }

    public SectionResource toResource(SectionContent sectionContent) {
        try {
            SectionResource resource = (SectionResource)((Object)sectionContent.accept((SectionContentVisitor)this));
            resource.add(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).get(sectionContent.getDocumentId().getId())).withRel("pmbok.doc"));
            return resource;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SectionResource visit(TitleSectionContent content) throws Exception {
        SectionResource resource = this.instantiateResource((SectionContent)content);
        resource.setContent((Object)this.titleSectionResourceAssembler.toResource(content));
        return resource;
    }

    public SectionResource visit(HistorySectionContent content) throws Exception {
        SectionResource resource = this.instantiateResource((SectionContent)content);
        resource.setContent(this.historyEntryResourceAssembler.toResources(content.getHistoryEntries()));
        return resource;
    }

    public SectionResource visit(ReferenceSectionContent content) throws Exception {
        SectionResource resource = this.instantiateResource((SectionContent)content);
        List refContent = new ReferenceResourceAssembler(content.getDocumentId(), true, false).toResources(content.getReferences());
        resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).associateReference(content.getDocumentId().getId(), "REFERENCE_ID")).withRel("pmbok.section.associate-reference")));
        resource.add(ControllerLinkBuilder.linkTo(((ReferenceController)ControllerLinkBuilder.methodOn(ReferenceController.class, (Object[])new Object[0])).search(null, null, content.getDocumentId().getId(), null)).withRel("pmbok.section.reference.search"));
        resource.setContent(refContent);
        return resource;
    }

    public SectionResource visit(TermSectionContent content) throws Exception {
        SectionResource resource = this.instantiateResource((SectionContent)content);
        List termContent = new TermResourceAssembler(content.getDocumentId(), true, false).toResources(content.getTerms());
        resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).associateTerm(content.getDocumentId().getId(), "TERM_ID")).withRel("pmbok.section.associate-term")));
        resource.add(ControllerLinkBuilder.linkTo(((TermController)ControllerLinkBuilder.methodOn(TermController.class, (Object[])new Object[0])).search(null, null, content.getDocumentId().getId(), null)).withRel("pmbok.section.term.search"));
        resource.setContent(termContent);
        return resource;
    }

    public SectionResource visit(TextSectionContent content) throws Exception {
        SectionResource resource = this.instantiateResource((SectionContent)content);
        resource.setContent(content.getText());
        resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).updateText(content.getDocumentId().getId(), content.getSectionTemplate().getSectionTemplateId().getId(), null)).withRel("pmbok.section.update-text")));
        return resource;
    }

    public SectionResource visit(TocSectionContent content) throws Exception {
        SectionResource resource = this.instantiateResource((SectionContent)content);
        resource.setContent(content.getTocElements());
        return resource;
    }
}

