/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.project;

import com.clusterra.pmbok.project.domain.service.IncorrectProjectVersionException;
import com.clusterra.pmbok.project.domain.service.ProjectNotFoundException;
import com.clusterra.pmbok.project.domain.service.ProjectVersionNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ProjectExceptionHandler {
    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(BindException exception) {
        return exception.getAllErrors();
    }

    @ExceptionHandler(value={IncorrectProjectVersionException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<FieldError> handle(IncorrectProjectVersionException exception) {
        return Arrays.asList(new FieldError("projectVersion", "value", exception.getMessage()));
    }

    @ExceptionHandler(value={ProjectVersionNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public List<FieldError> handle(ProjectVersionNotFoundException exception) {
        return Arrays.asList(new FieldError("projectVersion", "value", exception.getMessage()));
    }

    @ExceptionHandler(value={ProjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="project not found")
    @ResponseBody
    public List<FieldError> handle(ProjectNotFoundException exception) {
        return Arrays.asList(new FieldError("project", "id", exception.getMessage()));
    }
}

