/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.project.resource;

import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.iam.core.application.user.UserNotFoundException;
import com.clusterra.iam.core.application.user.UserQueryService;
import com.clusterra.pmbok.project.domain.model.Project;
import com.clusterra.pmbok.project.domain.service.ProjectNotFoundException;
import com.clusterra.pmbok.project.domain.service.ProjectVersionNotFoundException;
import com.clusterra.pmbok.rest.document.DocumentController;
import com.clusterra.pmbok.rest.project.ProjectController;
import com.clusterra.pmbok.rest.project.resource.ProjectResource;
import com.clusterra.rest.util.LinkWithMethodBuilder;
import com.clusterra.rest.util.RestMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class ProjectResourceAssembler
extends ResourceAssemblerSupport<Project, ProjectResource> {
    @Autowired
    private UserQueryService userQueryService;

    public ProjectResourceAssembler() {
        super(ProjectController.class, ProjectResource.class);
    }

    protected ProjectResource instantiateResource(Project entity) {
        try {
            String createdBy = this.userQueryService.findUser(entity.getCreatedByUserId()).getPerson().getDisplayName();
            String modifiedBy = this.userQueryService.findUser(entity.getModifiedByUserId()).getPerson().getDisplayName();
            return new ProjectResource(entity.getProjectId().getId(), entity.getName(), createdBy, entity.getCreatedDate(), modifiedBy, entity.getModifiedDate());
        }
        catch (UserNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ProjectResource toResource(Project project) {
        try {
            ProjectResource resource = (ProjectResource)this.createResourceWithId(project.getProjectId().getId(), project);
            resource.add(LinkWithMethodBuilder.linkWithMethodDelete(ControllerLinkBuilder.linkTo(((ProjectController)ControllerLinkBuilder.methodOn(ProjectController.class, (Object[])new Object[0])).delete(project.getProjectId().getId())).withRel(RestMethods.DELETE.getName())));
            resource.add(LinkWithMethodBuilder.linkWithMethodGet(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).search(null, project.getProjectId().getId(), null, null, null)).withRel("pmbok.documents.search.by-project")));
            resource.add(LinkWithMethodBuilder.linkWithMethodGet(ControllerLinkBuilder.linkTo(((ProjectController)ControllerLinkBuilder.methodOn(ProjectController.class, (Object[])new Object[0])).getVersions(project.getProjectId().getId())).withRel("pmbok.project.versions")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((ProjectController)ControllerLinkBuilder.methodOn(ProjectController.class, (Object[])new Object[0])).getVersions(project.getProjectId().getId())).withRel("pmbok.project.versions.create")));
            return resource;
        }
        catch (NotAuthenticatedException | ProjectNotFoundException | ProjectVersionNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

