/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.project.resource;

import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.project.domain.model.ProjectVersion;
import com.clusterra.pmbok.project.domain.service.ProjectNotFoundException;
import com.clusterra.pmbok.project.domain.service.ProjectVersionNotFoundException;
import com.clusterra.pmbok.rest.document.DocumentController;
import com.clusterra.pmbok.rest.project.ProjectController;
import com.clusterra.pmbok.rest.project.resource.ProjectVersionResource;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class ProjectVersionResourceAssembler
extends ResourceAssemblerSupport<ProjectVersion, ProjectVersionResource> {
    public ProjectVersionResourceAssembler() {
        super(ProjectController.class, ProjectVersionResource.class);
    }

    protected ProjectVersionResource instantiateResource(ProjectVersion entity) {
        return new ProjectVersionResource(entity.getProjectVersionId().getId(), entity.getLabel(), entity.getValue(), entity.isMain());
    }

    public ProjectVersionResource toResource(ProjectVersion version) {
        try {
            ProjectVersionResource resource = (ProjectVersionResource)this.createResourceWithId(version.getProjectVersionId(), version, new Object[]{version.getProject().getProjectId()});
            resource.add(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).search(null, null, version.getProjectVersionId().getId(), null, null)).withRel("pmbok.documents.by-project-version"));
            resource.add(ControllerLinkBuilder.linkTo(((ProjectController)ControllerLinkBuilder.methodOn(ProjectController.class, (Object[])new Object[0])).docTypes(version.getProjectVersionId().getId())).withRel("pmbok.project.version.available-document-types"));
            resource.add(ControllerLinkBuilder.linkTo(((ProjectController)ControllerLinkBuilder.methodOn(ProjectController.class, (Object[])new Object[0])).deleteVersion(version.getProjectVersionId().getId())).withRel("pmbok.project.version.delete"));
            return resource;
        }
        catch (NotAuthenticatedException | ProjectNotFoundException | ProjectVersionNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

