/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.project.validate;

import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.project.domain.model.repo.ProjectRepository;
import com.clusterra.pmbok.rest.project.validate.UniqueInTenant;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UniqueInTenantConstraintValidator
implements ConstraintValidator<UniqueInTenant, String> {
    private static final Logger logger = LoggerFactory.getLogger(UniqueInTenantConstraintValidator.class);
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private IdentityTracker identityTracker;

    public void initialize(UniqueInTenant uu) {
    }

    public boolean isValid(String name, ConstraintValidatorContext cxt) {
        try {
            String id = this.identityTracker.currentTenant().getId();
            return name != null && this.projectRepository.findByTenantIdAndName(id, name) == null;
        }
        catch (NotAuthenticatedException e) {
            throw new RuntimeException(e);
        }
    }
}

