/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.reference;

import com.clusterra.iam.core.application.tenant.TenantNotFoundException;
import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.application.document.DocumentQueryService;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.reference.application.ReferenceService;
import com.clusterra.pmbok.reference.domain.model.reference.Reference;
import com.clusterra.pmbok.reference.domain.model.reference.ReferenceId;
import com.clusterra.pmbok.reference.domain.service.ReferenceNotFoundException;
import com.clusterra.pmbok.rest.reference.ReferencePod;
import com.clusterra.pmbok.rest.reference.resource.ReferenceResource;
import com.clusterra.pmbok.rest.reference.resource.ReferenceResourceAssembler;
import com.clusterra.rest.util.ResponseMessage;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"pmbok/references"}, produces={"application/json"})
public class ReferenceController {
    @Autowired
    private ReferenceService referenceService;
    @Autowired
    private IdentityTracker identityTracker;
    @Autowired
    private ReferenceResourceAssembler referenceResourceAssembler;
    @Autowired
    private DocumentQueryService documentQueryService;

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseEntity<ReferenceResource> create(@Valid @RequestBody ReferencePod pod) throws NotAuthenticatedException, TenantNotFoundException {
        Reference reference = this.referenceService.create(this.identityTracker.currentTenant(), pod.getNumber(), pod.getName(), pod.getPublicationDate(), pod.getAuthor());
        return new ResponseEntity((Object)this.referenceResourceAssembler.toResource(reference), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<ReferenceResource> get(@PathVariable String id) throws ReferenceNotFoundException {
        Reference reference = this.referenceService.findBy(new ReferenceId(id));
        return new ResponseEntity((Object)this.referenceResourceAssembler.toResource(reference), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<ReferenceResource> update(@PathVariable String id, @Valid @RequestBody ReferencePod pod) throws ReferenceNotFoundException {
        Reference reference = this.referenceService.update(new ReferenceId(id), pod.getNumber(), pod.getName(), pod.getPublicationDate(), pod.getAuthor());
        return new ResponseEntity((Object)this.referenceResourceAssembler.toResource(reference), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<DefaultMessageSourceResolvable> delete(@PathVariable String id) throws ReferenceNotFoundException {
        this.referenceService.delete(new ReferenceId(id));
        return new ResponseEntity((Object)ResponseMessage.message("deleted"), HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public ResponseEntity<PagedResources<ReferenceResource>> search(@PageableDefault Pageable pageable, @RequestParam(required=false, defaultValue="") String searchBy, @RequestParam(required=false, defaultValue="") String documentId, PagedResourcesAssembler<Reference> assembler) throws NotAuthenticatedException, DocumentNotFoundException, SectionTemplateNotFoundException {
        if (!StringUtils.isEmpty((CharSequence)documentId)) {
            DocumentId docId = new DocumentId(documentId);
            Page referencePage = this.documentQueryService.getAssociatedReferences(pageable, docId, searchBy);
            return new ResponseEntity((Object)assembler.toResource(referencePage, (ResourceAssembler)new ReferenceResourceAssembler(docId, true, false)), HttpStatus.OK);
        }
        Page referencePage = this.referenceService.findBy(pageable, searchBy);
        return new ResponseEntity((Object)assembler.toResource(referencePage, (ResourceAssembler)this.referenceResourceAssembler), HttpStatus.OK);
    }
}

