/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.reference;

import com.clusterra.pmbok.reference.application.csv.InvalidCsvReferenceContentException;
import com.clusterra.pmbok.reference.application.csv.ReferenceCsvLoaderException;
import com.clusterra.pmbok.reference.domain.service.ReferenceNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ReferenceExceptionHandler {
    @ExceptionHandler(value={ReferenceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(ReferenceNotFoundException exception) {
        return Arrays.asList(new ObjectError("reference", exception.getMessage()));
    }

    @ExceptionHandler(value={ReferenceCsvLoaderException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(ReferenceCsvLoaderException exception) {
        return Arrays.asList(new ObjectError("reference", exception.getMessage()));
    }

    @ExceptionHandler(value={InvalidCsvReferenceContentException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(InvalidCsvReferenceContentException exception) {
        return Arrays.asList(new ObjectError("reference", exception.getMessage()));
    }
}

