/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.reference.resource;

import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.reference.domain.model.reference.Reference;
import com.clusterra.pmbok.reference.domain.service.ReferenceNotFoundException;
import com.clusterra.pmbok.rest.document.DocumentController;
import com.clusterra.pmbok.rest.reference.ReferenceController;
import com.clusterra.pmbok.rest.reference.resource.ReferenceResource;
import com.clusterra.rest.util.LinkWithMethodBuilder;
import com.clusterra.rest.util.RestMethods;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class ReferenceResourceAssembler
extends ResourceAssemblerSupport<Reference, ReferenceResource> {
    private final DocumentId documentId;
    private final Boolean unAssociateLink;
    private final Boolean associateLink;

    public ReferenceResourceAssembler() {
        this(null, true, true);
    }

    public ReferenceResourceAssembler(DocumentId documentId, Boolean unAssociateLink, Boolean associateLink) {
        super(ReferenceController.class, ReferenceResource.class);
        this.documentId = documentId;
        this.unAssociateLink = unAssociateLink;
        this.associateLink = associateLink;
    }

    protected ReferenceResource instantiateResource(Reference entity) {
        return new ReferenceResource(entity.getReferenceId().getId(), entity.getNumber(), entity.getName(), entity.getPublicationDate(), entity.getAuthor());
    }

    public ReferenceResource toResource(Reference reference) {
        try {
            ReferenceResource resource = this.instantiateResource(reference);
            resource.add(LinkWithMethodBuilder.linkWithMethodGet(ControllerLinkBuilder.linkTo(((ReferenceController)ControllerLinkBuilder.methodOn(ReferenceController.class, (Object[])new Object[0])).get(resource.getReferenceId())).withSelfRel()));
            resource.add(LinkWithMethodBuilder.linkWithMethodPut(ControllerLinkBuilder.linkTo(((ReferenceController)ControllerLinkBuilder.methodOn(ReferenceController.class, (Object[])new Object[0])).update(resource.getReferenceId(), null)).withRel(RestMethods.UPDATE.getName())));
            resource.add(LinkWithMethodBuilder.linkWithMethodDelete(ControllerLinkBuilder.linkTo(((ReferenceController)ControllerLinkBuilder.methodOn(ReferenceController.class, (Object[])new Object[0])).delete(resource.getReferenceId())).withRel(RestMethods.DELETE.getName())));
            if (this.documentId != null && this.unAssociateLink.booleanValue()) {
                resource.add(LinkWithMethodBuilder.linkWithMethodDelete(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).unAssociateReference(this.documentId.getId(), reference.getReferenceId().getId())).withRel("pmbok.section.un-associate-reference")));
            }
            if (this.documentId != null && this.associateLink.booleanValue()) {
                resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).associateReference(this.documentId.getId(), reference.getReferenceId().getId())).withRel("pmbok.section.associate-reference")));
            }
            return resource;
        }
        catch (NotAuthenticatedException | SectionTemplateNotFoundException | DocumentNotFoundException | ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

