/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.template;

import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.application.template.TemplateService;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.model.template.TemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplate;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplateId;
import com.clusterra.pmbok.document.domain.model.template.section.SectionType;
import com.clusterra.pmbok.document.domain.service.template.TemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import com.clusterra.pmbok.rest.template.NamePod;
import com.clusterra.pmbok.rest.template.SectionOrderPod;
import com.clusterra.pmbok.rest.template.TemplatePod;
import com.clusterra.pmbok.rest.template.resource.SectionTemplateResource;
import com.clusterra.pmbok.rest.template.resource.SectionTemplateResourceAssembler;
import com.clusterra.pmbok.rest.template.resource.SectionTypeResource;
import com.clusterra.pmbok.rest.template.resource.SectionTypeResourceAssembler;
import com.clusterra.pmbok.rest.template.resource.TemplateResource;
import com.clusterra.pmbok.rest.template.resource.TemplateResourceAssembler;
import com.clusterra.rest.util.ResponseMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"pmbok/templates"}, produces={"application/json"})
public class TemplateController {
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateResourceAssembler templateResourceAssembler;
    @Autowired
    private SectionTemplateResourceAssembler sectionTemplateResourceAssembler;
    @Autowired
    private SectionTypeResourceAssembler sectionTypeResourceAssembler;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseEntity<TemplateResource> create(@Valid @RequestBody TemplatePod pod, BindingResult bindingResult) throws BindException, NotAuthenticatedException, TemplateAlreadyExistsException {
        if (bindingResult.hasErrors()) {
            throw new BindException(bindingResult);
        }
        Template template = this.templateService.createTemplate(pod.getMajorVersion(), pod.getMinorVersion(), pod.getName());
        return new ResponseEntity((Object)this.templateResourceAssembler.toResource(template), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<TemplateResource> updateTemplateName(@PathVariable String id, @Valid @RequestBody NamePod pod) throws TemplateNotFoundException {
        Template template = this.templateService.updateTemplateName(new TemplateId(id), pod.getName());
        return new ResponseEntity((Object)this.templateResourceAssembler.toResource(template), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<DefaultMessageSourceResolvable> delete(@PathVariable String id) throws TemplateNotFoundException {
        this.templateService.deleteTemplate(new TemplateId(id));
        return new ResponseEntity((Object)ResponseMessage.message("template deleted"), HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<TemplateResource> get(@PathVariable String id) throws TemplateNotFoundException {
        Template template = this.templateService.findBy(new TemplateId(id));
        return new ResponseEntity((Object)this.templateResourceAssembler.toResource(template), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/sections/add-history"}, method={RequestMethod.POST})
    public ResponseEntity<SectionTemplateResource> addHistorySection(@PathVariable String id, Locale locale) throws SectionTemplateAlreadyExistsException, TemplateNotFoundException {
        String name = this.messageSource.getMessage("document.section.history.title", null, "title_", locale);
        SectionTemplate section = this.templateService.addHistorySection(new TemplateId(id), name);
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(section), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}/sections/add-reference"}, method={RequestMethod.POST})
    public ResponseEntity<SectionTemplateResource> addReferenceSection(@PathVariable String id, Locale locale) throws SectionTemplateAlreadyExistsException, TemplateNotFoundException {
        String name = this.messageSource.getMessage("document.section.reference.title", null, "title_", locale);
        SectionTemplate section = this.templateService.addReferenceSection(new TemplateId(id), name);
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(section), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}/sections/add-term"}, method={RequestMethod.POST})
    public ResponseEntity<SectionTemplateResource> addTermSection(@PathVariable String id, Locale locale) throws SectionTemplateAlreadyExistsException, TemplateNotFoundException {
        String name = this.messageSource.getMessage("document.section.term.title", null, "title_", locale);
        SectionTemplate section = this.templateService.addTermSection(new TemplateId(id), name);
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(section), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}/sections/add-text"}, method={RequestMethod.POST})
    public ResponseEntity<SectionTemplateResource> addTextSection(@PathVariable String id, Locale locale) throws SectionTemplateAlreadyExistsException, TemplateNotFoundException {
        String name = this.messageSource.getMessage("document.section.plaint-text.title", null, "title_", locale);
        SectionTemplate section = this.templateService.addTextSection(new TemplateId(id), name);
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(section), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}/sections/add-contents"}, method={RequestMethod.POST})
    public ResponseEntity<SectionTemplateResource> addContentsSection(@PathVariable String id, Locale locale) throws SectionTemplateAlreadyExistsException, TemplateNotFoundException {
        String name = this.messageSource.getMessage("document.section.contents.title", null, "title_", locale);
        SectionTemplate section = this.templateService.addTocSection(new TemplateId(id), name);
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(section), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}/sections/add-title"}, method={RequestMethod.POST})
    public ResponseEntity<SectionTemplateResource> addTitleSection(@PathVariable String id, Locale locale) throws SectionTemplateAlreadyExistsException, TemplateNotFoundException {
        String name = this.messageSource.getMessage("document.section.title.title", null, "title_", locale);
        SectionTemplate section = this.templateService.addTitleSection(new TemplateId(id), name);
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(section), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}/sections/{sectionTemplateId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<DefaultMessageSourceResolvable> removeSection(@PathVariable String id, @PathVariable String sectionTemplateId) throws TemplateNotFoundException, SectionTemplateNotFoundException {
        this.templateService.removeSection(new TemplateId(id), new SectionTemplateId(sectionTemplateId));
        return new ResponseEntity((Object)ResponseMessage.message("section removed"), HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{id}/sections/{sectionTemplateId}"}, method={RequestMethod.GET})
    public ResponseEntity<SectionTemplateResource> getSection(@PathVariable String id, @PathVariable String sectionTemplateId) throws TemplateNotFoundException, SectionTemplateNotFoundException {
        SectionTemplate template = this.templateService.findSectionTemplateBy(new SectionTemplateId(sectionTemplateId));
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(template), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/sections"}, method={RequestMethod.GET})
    public ResponseEntity<List<SectionTemplateResource>> getSections(@PathVariable String id) throws TemplateNotFoundException {
        List sectionTemplates = this.templateService.findSectionTemplates(new TemplateId(id));
        List resources = this.sectionTemplateResourceAssembler.toResources(sectionTemplates);
        return new ResponseEntity((Object)resources, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/sections/{sectionTemplateId}/update-order"}, method={RequestMethod.PUT})
    public ResponseEntity<SectionTemplateResource> updateSectionOrder(@PathVariable String id, @PathVariable String sectionTemplateId, @Valid @RequestBody SectionOrderPod pod) throws TemplateNotFoundException, SectionTemplateNotFoundException {
        SectionTemplate sectionTemplate = this.templateService.updateSectionOrder(new TemplateId(id), new SectionTemplateId(sectionTemplateId), pod.getOrderIndex());
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(sectionTemplate), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/sections/{sectionTemplateId}/update-name"}, method={RequestMethod.PUT})
    public ResponseEntity<SectionTemplateResource> updateSectionName(@PathVariable String id, @PathVariable String sectionTemplateId, @Valid @RequestBody NamePod pod) throws TemplateNotFoundException, SectionTemplateNotFoundException {
        SectionTemplate sectionTemplate = this.templateService.updateSectionName(new TemplateId(id), new SectionTemplateId(sectionTemplateId), pod.getName());
        return new ResponseEntity((Object)this.sectionTemplateResourceAssembler.toResource(sectionTemplate), HttpStatus.OK);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public ResponseEntity<PagedResources<TemplateResource>> search(@PageableDefault Pageable pageable, @RequestParam(required=false) String searchBy, PagedResourcesAssembler<Template> assembler) throws NotAuthenticatedException {
        Page page = this.templateService.findBy(pageable, searchBy);
        return new ResponseEntity((Object)assembler.toResource(page, (ResourceAssembler)this.templateResourceAssembler), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/available-section-types"})
    public ResponseEntity<Resources<SectionTypeResource>> getAvailableSectionTypes(@PathVariable String id) throws TemplateNotFoundException {
        ArrayList<SectionType> all = new ArrayList<SectionType>(Arrays.asList(SectionType.values()));
        Set used = this.templateService.findSectionTypesUsedBy(new TemplateId(id));
        used.remove(SectionType.SECTION_TEXT);
        all.removeAll(used);
        return new ResponseEntity((Object)new Resources((Iterable)this.sectionTypeResourceAssembler.toResources(all), new Link[0]), HttpStatus.OK);
    }
}

