/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.template;

import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.service.document.listen.TemplateUsedException;
import com.clusterra.pmbok.document.domain.service.template.TemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class TemplateExceptionHandler {
    @ExceptionHandler(value={TemplateAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<FieldError> handle(TemplateAlreadyExistsException exception) {
        return Arrays.asList(new FieldError("template", "name", exception.getMessage()));
    }

    @ExceptionHandler(value={TemplateNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(TemplateNotFoundException exception) {
        return Arrays.asList(new ObjectError("template", exception.getMessage()));
    }

    @ExceptionHandler(value={SectionTemplateNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(SectionTemplateNotFoundException exception) {
        return Arrays.asList(new ObjectError("sectionTemplate", exception.getMessage()));
    }

    @ExceptionHandler(value={TemplateUsedException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(TemplateUsedException exception) {
        return Arrays.asList(new ObjectError("template", exception.getMessage()));
    }
}

