/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.template.resource;

import com.clusterra.iam.core.application.user.UserId;
import com.clusterra.iam.core.application.user.UserNotFoundException;
import com.clusterra.iam.core.application.user.UserQueryService;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.model.template.section.SectionTemplate;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import com.clusterra.pmbok.rest.template.TemplateController;
import com.clusterra.pmbok.rest.template.resource.SectionTemplateResource;
import com.clusterra.rest.util.LinkWithMethodBuilder;
import com.clusterra.rest.util.RestMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class SectionTemplateResourceAssembler
extends ResourceAssemblerSupport<SectionTemplate, SectionTemplateResource> {
    @Autowired
    private UserQueryService userQueryService;

    public SectionTemplateResourceAssembler() {
        super(TemplateController.class, SectionTemplateResource.class);
    }

    protected SectionTemplateResource instantiateResource(SectionTemplate entity) {
        try {
            String createdBy = this.getDisplayName(entity.getCreatedByUserId());
            String modifiedBy = this.getDisplayName(entity.getModifiedByUserId());
            return new SectionTemplateResource(entity.getSectionTemplateId().getId(), entity.getName(), entity.getCreatedDate(), createdBy, entity.getModifiedDate(), modifiedBy, entity.getType().name(), entity.getOrderIndex());
        }
        catch (UserNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDisplayName(String userId) throws UserNotFoundException {
        if (userId == null) {
            return "n/a";
        }
        return this.userQueryService.findUser(new UserId(userId)).getPerson().getDisplayName();
    }

    public SectionTemplateResource toResource(SectionTemplate entity) {
        SectionTemplateResource resource = this.instantiateResource(entity);
        try {
            String templateId = entity.getTemplate().getTemplateId().getId();
            String sectionTemplateId = entity.getSectionTemplateId().getId();
            resource.add(LinkWithMethodBuilder.linkWithMethodGet(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).getSection(templateId, sectionTemplateId)).withSelfRel()));
            resource.add(LinkWithMethodBuilder.linkWithMethodPut(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).updateSectionOrder(templateId, sectionTemplateId, null)).withRel("pmbok.templates.section.set-order")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPut(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).updateSectionName(templateId, sectionTemplateId, null)).withRel("pmbok.templates.section.set-name")));
            resource.add(LinkWithMethodBuilder.linkWithMethodDelete(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).removeSection(templateId, sectionTemplateId)).withRel(RestMethods.DELETE.getName())));
            return resource;
        }
        catch (SectionTemplateNotFoundException | TemplateNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

