/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.template.resource;

import com.clusterra.pmbok.document.domain.model.template.section.SectionType;
import com.clusterra.pmbok.rest.template.TemplateController;
import com.clusterra.pmbok.rest.template.resource.SectionTypeResource;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class SectionTypeResourceAssembler
extends ResourceAssemblerSupport<SectionType, SectionTypeResource> {
    @Autowired
    private MessageSource messageSource;

    public SectionTypeResourceAssembler() {
        super(TemplateController.class, SectionTypeResource.class);
    }

    protected SectionTypeResource instantiateResource(SectionType entity) {
        return new SectionTypeResource(entity, this.getName(entity), this.isMultiple(entity));
    }

    private Boolean isMultiple(SectionType entity) {
        switch (entity) {
            case SECTION_TITLE: {
                return false;
            }
            case SECTION_HISTORY: {
                return false;
            }
            case SECTION_REFERENCE: {
                return false;
            }
            case SECTION_TERM: {
                return false;
            }
            case SECTION_TEXT: {
                return true;
            }
            case SECTION_CONTENTS: {
                return false;
            }
        }
        return false;
    }

    private String getName(SectionType entity) {
        Locale locale = LocaleContextHolder.getLocale();
        switch (entity) {
            case SECTION_TITLE: {
                return this.messageSource.getMessage("document.section.title.title", null, "title_", locale);
            }
            case SECTION_HISTORY: {
                return this.messageSource.getMessage("document.section.history.title", null, "history_", locale);
            }
            case SECTION_REFERENCE: {
                return this.messageSource.getMessage("document.section.reference.title", null, "reference_", locale);
            }
            case SECTION_TERM: {
                return this.messageSource.getMessage("document.section.term.title", null, "term_", locale);
            }
            case SECTION_TEXT: {
                return this.messageSource.getMessage("document.section.plaint-text.title", null, "plain_text_", locale);
            }
            case SECTION_CONTENTS: {
                return this.messageSource.getMessage("document.section.contents.title", null, "contents_", locale);
            }
        }
        throw new IllegalArgumentException("unknown section type " + entity);
    }

    public SectionTypeResource toResource(SectionType entity) {
        return this.instantiateResource(entity);
    }
}

