/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.template.resource;

import com.clusterra.iam.core.application.user.UserId;
import com.clusterra.iam.core.application.user.UserNotFoundException;
import com.clusterra.iam.core.application.user.UserQueryService;
import com.clusterra.pmbok.document.domain.model.document.repo.DocumentRepository;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateAlreadyExistsException;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.document.domain.service.template.TemplateNotFoundException;
import com.clusterra.pmbok.rest.template.TemplateController;
import com.clusterra.pmbok.rest.template.resource.TemplateResource;
import com.clusterra.rest.util.LinkWithMethodBuilder;
import com.clusterra.rest.util.RestMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class TemplateResourceAssembler
extends ResourceAssemblerSupport<Template, TemplateResource> {
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private DocumentRepository documentRepository;

    public TemplateResourceAssembler() {
        super(TemplateController.class, TemplateResource.class);
    }

    protected TemplateResource instantiateResource(Template entity) {
        try {
            String createdBy = this.getDisplayName(entity.getCreatedByUserId());
            String modifiedBy = this.getDisplayName(entity.getModifiedByUserId());
            Integer usageCount = this.documentRepository.countBy(entity);
            return new TemplateResource(entity.getTemplateId().getId(), entity.getName(), entity.getCreatedDate(), createdBy, entity.getModifiedDate(), modifiedBy, entity.getVersion().getAsString(), usageCount);
        }
        catch (UserNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDisplayName(String userId) throws UserNotFoundException {
        if (userId == null) {
            return "n/a";
        }
        return this.userQueryService.findUser(new UserId(userId)).getPerson().getDisplayName();
    }

    public TemplateResource toResource(Template entity) {
        TemplateResource resource = this.instantiateResource(entity);
        try {
            String templateId = entity.getTemplateId().getId();
            resource.add(LinkWithMethodBuilder.linkWithMethodGet(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).get(templateId)).withSelfRel()));
            resource.add(LinkWithMethodBuilder.linkWithMethodDelete(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).delete(templateId)).withRel(RestMethods.DELETE.getName())));
            resource.add(LinkWithMethodBuilder.linkWithMethodGet(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).getSections(templateId)).withRel("pmbok.templates.sections")));
            resource.add(LinkWithMethodBuilder.linkWithMethodGet(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).getAvailableSectionTypes(templateId)).withRel("pmbok.templates.section-types")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).addHistorySection(templateId, null)).withRel("pmbok.templates.section.add-history")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).addTermSection(templateId, null)).withRel("pmbok.templates.section.add-term")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).addReferenceSection(templateId, null)).withRel("pmbok.templates.section.add-reference")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).addTextSection(templateId, null)).withRel("pmbok.templates.section.add-text")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).addTitleSection(templateId, null)).withRel("pmbok.templates.section.add-title")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).addContentsSection(templateId, null)).withRel("pmbok.templates.section.add-contents")));
            resource.add(LinkWithMethodBuilder.linkWithMethodPut(ControllerLinkBuilder.linkTo(((TemplateController)ControllerLinkBuilder.methodOn(TemplateController.class, (Object[])new Object[0])).updateTemplateName(templateId, null)).withRel("pmbok.templates.set-name")));
            return resource;
        }
        catch (SectionTemplateAlreadyExistsException | TemplateNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

