/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.term;

import com.clusterra.iam.core.application.tenant.TenantNotFoundException;
import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.application.document.DocumentQueryService;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.rest.term.TermPod;
import com.clusterra.pmbok.rest.term.resource.TermResource;
import com.clusterra.pmbok.rest.term.resource.TermResourceAssembler;
import com.clusterra.pmbok.term.application.TermService;
import com.clusterra.pmbok.term.domain.model.term.Term;
import com.clusterra.pmbok.term.domain.model.term.TermId;
import com.clusterra.pmbok.term.domain.service.TermNotFoundException;
import com.clusterra.rest.util.ResponseMessage;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"pmbok/terms"}, produces={"application/json"})
public class TermController {
    @Autowired
    private TermService termService;
    @Autowired
    private IdentityTracker identityTracker;
    @Autowired
    private TermResourceAssembler termResourceAssembler;
    @Autowired
    private DocumentQueryService documentQueryService;

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseEntity<TermResource> create(@Valid @RequestBody TermPod pod) throws NotAuthenticatedException, TenantNotFoundException {
        Term term = this.termService.create(this.identityTracker.currentTenant(), pod.getName(), pod.getDescription());
        return new ResponseEntity((Object)this.termResourceAssembler.toResource(term), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<TermResource> get(@PathVariable String id) throws TermNotFoundException {
        Term term = this.termService.findBy(new TermId(id));
        return new ResponseEntity((Object)this.termResourceAssembler.toResource(term), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<TermResource> update(@PathVariable String id, @RequestBody TermPod pod) throws TermNotFoundException {
        Term term = this.termService.update(new TermId(id), pod.getName(), pod.getDescription());
        return new ResponseEntity((Object)this.termResourceAssembler.toResource(term), HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<DefaultMessageSourceResolvable> delete(@PathVariable String id) throws TermNotFoundException {
        this.termService.delete(new TermId(id));
        return new ResponseEntity((Object)ResponseMessage.message("term deleted"), HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public ResponseEntity<PagedResources<TermResource>> search(@PageableDefault Pageable pageable, @RequestParam(required=false) String searchBy, @RequestParam(required=false) String documentId, PagedResourcesAssembler<Term> assembler) throws NotAuthenticatedException, DocumentNotFoundException, SectionTemplateNotFoundException {
        if (!StringUtils.isEmpty((CharSequence)documentId)) {
            DocumentId docId = new DocumentId(documentId);
            Page termPage = this.documentQueryService.getAssociatedTerms(pageable, docId, searchBy);
            return new ResponseEntity((Object)assembler.toResource(termPage, (ResourceAssembler)new TermResourceAssembler(docId, true, false)), HttpStatus.OK);
        }
        Page termPage = this.termService.findBy(pageable, searchBy);
        return new ResponseEntity((Object)assembler.toResource(termPage, (ResourceAssembler)this.termResourceAssembler), HttpStatus.OK);
    }
}

