/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.term;

import com.clusterra.iam.core.application.tenant.TenantNotFoundException;
import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.iam.core.protect.Protected;
import com.clusterra.iam.session.application.SessionLobStorage;
import com.clusterra.iam.session.application.SessionStorageKey;
import com.clusterra.pmbok.rest.uploadcsv.CsvFileValidator;
import com.clusterra.pmbok.rest.uploadcsv.CsvSessionKey;
import com.clusterra.pmbok.rest.uploadcsv.InvalidCsvFileException;
import com.clusterra.pmbok.term.application.csv.InvalidCsvTermContentException;
import com.clusterra.pmbok.term.application.csv.TermCsvLoader;
import com.clusterra.pmbok.term.application.csv.TermCsvLoaderException;
import com.clusterra.rest.util.ResponseMessage;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"pmbok/terms"})
public class TermUploadController {
    @Autowired
    private IdentityTracker identityTracker;
    @Autowired
    private SessionLobStorage sessionLobStorage;
    @Autowired
    private TermCsvLoader termCsvLoader;

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResponseEntity<String> upload(@RequestParam(required=false) String token, @RequestParam(required=false) MultipartFile file) throws IOException, InvalidCsvFileException, InvalidCsvTermContentException {
        Validate.notEmpty((CharSequence)token);
        Validate.notNull((Object)file, (String)"file is null, make sure Content-Disposition:name='file'", (Object[])new Object[0]);
        CsvFileValidator.validate(file);
        byte[] bytes = file.getBytes();
        this.termCsvLoader.validateContent(bytes);
        this.sessionLobStorage.store(token, (SessionStorageKey)CsvSessionKey.UPLOAD_CSV_SESSION_KEY, (Object)bytes);
        return new ResponseEntity((Object)file.getOriginalFilename(), HttpStatus.OK);
    }

    @RequestMapping(value={"/load"}, method={RequestMethod.POST})
    @Protected(actions={"See Personal Details"})
    public ResponseEntity<DefaultMessageSourceResolvable> load(@RequestParam(required=false) String token) throws TermCsvLoaderException, NotAuthenticatedException, TenantNotFoundException {
        byte[] result = (byte[])this.sessionLobStorage.retrieve(token, (SessionStorageKey)CsvSessionKey.UPLOAD_CSV_SESSION_KEY);
        try {
            this.termCsvLoader.loadFromCsv(this.identityTracker.currentTenant(), result);
        }
        finally {
            this.sessionLobStorage.remove(token, (SessionStorageKey)CsvSessionKey.UPLOAD_CSV_SESSION_KEY);
        }
        return new ResponseEntity((Object)ResponseMessage.message("loaded"), HttpStatus.OK);
    }
}

