/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.term.resource;

import com.clusterra.iam.core.application.tracker.NotAuthenticatedException;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.template.SectionTemplateNotFoundException;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.rest.document.DocumentController;
import com.clusterra.pmbok.rest.term.TermController;
import com.clusterra.pmbok.rest.term.resource.TermResource;
import com.clusterra.pmbok.term.domain.model.term.Term;
import com.clusterra.pmbok.term.domain.service.TermNotFoundException;
import com.clusterra.rest.util.LinkWithMethodBuilder;
import com.clusterra.rest.util.RestMethods;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class TermResourceAssembler
extends ResourceAssemblerSupport<Term, TermResource> {
    private final DocumentId documentId;
    private final Boolean unAssociateLink;
    private final Boolean associateLink;

    public TermResourceAssembler() {
        this(null, true, true);
    }

    public TermResourceAssembler(DocumentId documentId, Boolean unAssociateLink, Boolean associateLink) {
        super(TermController.class, TermResource.class);
        this.documentId = documentId;
        this.unAssociateLink = unAssociateLink;
        this.associateLink = associateLink;
    }

    protected TermResource instantiateResource(Term entity) {
        return new TermResource(entity.getTermId().getId(), entity.getCreatedDate(), entity.getCreatedByUserId(), entity.getModifiedDate(), entity.getModifiedByUserId(), entity.getName(), entity.getDescription());
    }

    public TermResource toResource(Term term) {
        try {
            TermResource resource = (TermResource)this.createResourceWithId(term.getTermId(), term);
            resource.add(LinkWithMethodBuilder.linkWithMethodPut(ControllerLinkBuilder.linkTo(((TermController)ControllerLinkBuilder.methodOn(TermController.class, (Object[])new Object[0])).get(resource.getTermId())).withSelfRel()));
            resource.add(LinkWithMethodBuilder.linkWithMethodPut(ControllerLinkBuilder.linkTo(((TermController)ControllerLinkBuilder.methodOn(TermController.class, (Object[])new Object[0])).update(resource.getTermId(), null)).withRel(RestMethods.UPDATE.getName())));
            resource.add(LinkWithMethodBuilder.linkWithMethodDelete(ControllerLinkBuilder.linkTo(((TermController)ControllerLinkBuilder.methodOn(TermController.class, (Object[])new Object[0])).delete(resource.getTermId())).withRel(RestMethods.DELETE.getName())));
            if (this.documentId != null && this.unAssociateLink.booleanValue()) {
                resource.add(LinkWithMethodBuilder.linkWithMethodDelete(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).unAssociateTerm(this.documentId.getId(), term.getTermId().getId())).withRel("pmbok.section.un-associate-term")));
            }
            if (this.documentId != null && this.associateLink.booleanValue()) {
                resource.add(LinkWithMethodBuilder.linkWithMethodPost(ControllerLinkBuilder.linkTo(((DocumentController)ControllerLinkBuilder.methodOn(DocumentController.class, (Object[])new Object[0])).associateTerm(this.documentId.getId(), term.getTermId().getId())).withRel("pmbok.section.associate-term")));
            }
            return resource;
        }
        catch (NotAuthenticatedException | SectionTemplateNotFoundException | DocumentNotFoundException | TermNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

