/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.rest.uploadcsv;

import com.clusterra.pmbok.rest.uploadcsv.InvalidCsvFileException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
public class CsvUploadExceptionHandler {
    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(BindException exception) {
        return exception.getAllErrors();
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(MaxUploadSizeExceededException exception) {
        return Arrays.asList(new ObjectError("file", "Maximum upload size of " + exception.getMaxUploadSize() + "bytes exceeded"));
    }

    @ExceptionHandler(value={InvalidCsvFileException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ResponseBody
    public List<ObjectError> handle(InvalidCsvFileException exception) {
        return Arrays.asList(new ObjectError("file", exception.getMessage()));
    }
}

